% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Max_policy_dynamic.R
\name{Max_policy_dynamic}
\alias{Max_policy_dynamic}
\title{Max_policy_dynamic}
\usage{
Max_policy_dynamic(
  demand,
  forecast,
  leadtime,
  service_level,
  initial_inventory_level = FALSE,
  one_step_forecast = TRUE,
  shortage_cost = FALSE,
  inventory_cost = FALSE,
  ordering_cost = FALSE,
  distribution = "normal",
  error_metric = "rmse",
  metric_windows = FALSE,
  plot = FALSE
)
}
\arguments{
\item{demand}{A vector of demand in N time periods.}

\item{forecast}{the forecast vector of equal n periods to demand.}

\item{leadtime}{lead time from order to arrival (order to delivery time)}

\item{service_level}{cycle service level requested}

\item{initial_inventory_level}{integer,Default is False and simulation starts with min as inventory level}

\item{one_step_forecast}{logical, Default is true where demand lead time is calcluated as(forecast at period t * leadtime)
while if False, demand
leadtime is calculated as (forecast of period t to forecast of period t+leadtime-1)}

\item{shortage_cost}{numeric,Default is FALSE shortage cost per unit of sales lost}

\item{inventory_cost}{numeric,Default is FALSE inventory cost per unit.}

\item{ordering_cost}{numeric,Default is FALSE ordering cost for every time an order is made.}

\item{distribution}{distribution  to calculate safety stock based on demand distribution, current choices are 'normal' or 'poisson'}

\item{error_metric}{metric is currently 'rmse' and 'mae', this calculates the error from period 1 to period t unless metric_windows is set.
this contributes to the calculation of saftey stock. default is 'rmse'}

\item{metric_windows}{integer, for example if it is set to 4 rmse for t is calculated from t-1 to t-4,default is FALSE}

\item{plot}{Logical, Default is False, if true a plot is generated}
}
\value{
a list of two date frames, the simulation and the metrics. the metrics are (1) shortage cost, (2) inventory cost which
is the cost of one unit of inventory in one period,(3) which is the average inventory level per period, (4) total orders made in the 
simulation, (5) ordering cost if any, (6) total lost sales if any,(7) average ordering quantity across all orders,(8) ordering
interval which is the average time between each order,(9) item fill rate,(10) cycle service level, (11) average saftey stock in each
period,(12) the average sales in every order,(13) overall root mean square error, (14) overall mean absolute error, 
(14) overall mean  error,(15) overall mean absolute percentage error,(16) the average flowttime which is the average time 
a unit spends on inventory and (17) the demand classification.
}
\description{
Simulating a  max policy or also called S policy, the Max is dynamically calculated based on a forecast vector.
}
\details{
The Function takes a demand vector, mean of demand ,sd,lead time and requested service level to simulate an inventory system, 
 orders are lost if inventory level is less than requested demand, also ordering is made at
 day t+1, metrics like item fill rate and cycle service level are calculated. 
 the min is calculated based on a normal distribution or a poisson distribution, also min can be set manually.
 and order is equal to max((Max[t]-inventory position [t-1])+ sales[t],0)
}
\examples{
Max_policy_dynamic(demand = rnorm(90,9,2),forecast = rpois(90,9) ,
service_level = 0.7,leadtime = 10)
}
\author{
"haytham omar  email: <haytham@rescaleanalytics.com>"
}
