% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conc_scale_use.R
\name{conc_scale_use}
\alias{conc_scale_use}
\title{Get concentration scalings}
\usage{
conc_scale_use(use_scale_conc, obj)
}
\arguments{
\item{use_scale_conc}{The `use_scale_conc` argument (see Details)}

\item{obj}{A [pk()] object}
}
\value{
A named list with elements `dose_norm` and `log10_trans`, both
  logical.
}
\description{
A helper function to get concentration scalings
}
\details{
In methods applied to fitted [pk()] objects that also accept `newdata`
arguments, the user may specify whether to use the concentration scaling of
the fitted [pk()] object, or use a different concentration scaling. This is
done by specifying an argument `use_scale_conc`, which may be `TRUE` (to use
the scaling from the fitted object), `FALSE` (to use no scaling), or may be a
named list with elements `dose_norm` and `log10_trans` to specify
scaling/transformation directly. This helper function parses the
`use_scale_conc` argument.
}
