% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supplementary_add.R
\name{supplementary_add}
\alias{supplementary_add}
\title{Add supplementary data}
\usage{
supplementary_add(data_table, supplementary_data, supplementary_names = NULL)
}
\arguments{
\item{data_table}{A SIOT, a use table, a supply table, or a margins 
table.}

\item{supplementary_data}{Supplementary data to be added. 
It must be a data.frame
or tibble with a key column containing the indicator's name, 
and the column names must match with the \code{data_table}. Can be a 
vector or a data frame of several rows.}

\item{supplementary_names}{Optional names for the new supplementary rows. 
Defaults  to \code{NULL}.}
}
\value{
An extended \code{data_table} with the new row(s) binded.

A symmetric input-output table with supplementary data,  
of data.frame class. 
The column names are ordered, and the row names are in the 
first, auxiliary metadata column.
}
\description{
Add supplementary data to a SIOT, a use, supply or margins table.
}
\details{
This function is a wrapper around the more general \code{\link{rows_add}} function.
}
\examples{
de_io <- iotable_get()
CO2_coefficients <- data.frame(agriculture_group = 0.2379,
                               industry_group    = 0.5172, 
                               construction = 0.0456,
                               trade_group = 0.1320, 
                               business_services_group = 0.0127,
                               other_services_group = 0.0530)
CH4_coefficients <- data.frame(agriculture_group = 0.0349,
                               industry_group    = 0.0011, 
                               construction = 0,
                               trade_group = 0, 
                               business_services_group = 0,
                               other_services_group = 0.0021)
CO2 <- cbind (data.frame(iotables_row = "CO2"), 
              CO2_coefficients)
CH4 <- cbind(data.frame (iotables_row = "CH4_coefficients"),
             CH4_coefficients)
de_coeff <- input_coefficient_matrix_create ( iotable_get() )
emissions <- rbind (CO2, CH4)

# Check with the Eurostat Manual page 494:
supplementary_add(de_io, emissions)
}
\seealso{
Other iotables processing functions: 
\code{\link{conforming_vector_create}()},
\code{\link{household_column_get}()},
\code{\link{iotable_year_get}()},
\code{\link{key_column_create}()},
\code{\link{matrix_round}()},
\code{\link{output_get}()},
\code{\link{primary_input_get}()},
\code{\link{rows_add}()},
\code{\link{total_tax_add}()},
\code{\link{vector_transpose_longer}()},
\code{\link{vector_transpose_wider}()}
}
\concept{iotables processing functions}
