% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{EM_algo_c}
\alias{EM_algo_c}
\title{Parameter estimation via EM Algorithm with Condition Stage}
\usage{
EM_algo_c(
  obs_pattern_shape,
  obs_pattern_frq,
  obs_internal_count,
  categorical_levels,
  random_starts,
  max_iterations,
  rel_convergence,
  con_step_size,
  con_random_starts,
  con_max_iterations,
  con_rel_convergence,
  trace,
  con_trace
)
}
\arguments{
\item{obs_pattern_shape}{\code{Matrix} containing the unique patterns found
in the data. Ideally this matrix is generated by the function
\code{get_patterns()}.}

\item{obs_pattern_frq}{\code{Vector} containing the frequencies of the
patterns. Ideally it is generated by the the function
\code{get_patterns()}.}

\item{obs_internal_count}{\code{Matrix} containing the relative frequencies
of each category within each pattern. Ideally this matrix is generated by
the function \code{get_patterns()}.}

\item{categorical_levels}{\code{Vector} containing all possible categories of
the content analysis.}

\item{random_starts}{\code{Integer} for determining how often the algorithm
should restart with randomly chosen values for the Assignment Error Matrix
and the categorical sizes.}

\item{max_iterations}{\code{Integer} for determining the maximum number of iterations
for each random start.}

\item{rel_convergence}{\code{Double} for determining the convergence criterion. The
algorithm stops if the relative change is smaller than this criterion.}

\item{con_step_size}{\code{Double} for specifying the size for increasing or
decreasing the probabilities during the condition stage of estimation.
This value should not be less than 1e-3.}

\item{con_random_starts}{\code{Integer} for the number of random starts
within the condition stage.}

\item{con_max_iterations}{\code{Integer} for the maximum number of iterations
during the condition stage.}

\item{con_rel_convergence}{\code{Double} for determining the convergence
criterion during condition stage. The algorithm stops if the relative change
is smaller than this criterion.}

\item{trace}{\code{TRUE} for printing progress information on the console.
\code{FALSE} if this information should not be printed.}

\item{con_trace}{\code{TRUE} for printing progress information on the console
during estimations in the condition stage. \code{FALSE} if this information
should not be printed.}
}
\value{
Function returns a \code{list} with the estimated parameter sets for
every random start. Every parameter set contains the following components:
\item{log_likelihood}{Log likelihood of the estimated solution.}
\item{aem}{Estimated Assignment Error Matrix (aem). The rows represent the
true categories while the columns stand for the assigned categories. The cells
describe the probability that a coding unit of category i is assigned to
category j.}
\item{categorial_sizes}{\code{Vector} of estimated sizes for each
category.}
\item{convergence}{If the algorithm converged within the iteration limit
\code{TRUE}. \code{FALSE} in every other case.}
\item{iteration}{Number of iterations when the algorithm was terminated.}
}
\description{
Function written in \code{C++} for estimating the parameters of the model
via Expectation Maximization (EM Algorithm).
}
\references{
Berding, Florian, and Pargmann, Julia (2022).Iota Reliability Concept
of the Second Generation.Measures for Content Analysis Done by
Humans or Artificial Intelligences. Berlin: Logos.
https://doi.org/10.30819/5581
}
