% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{est_con_multinominal_c}
\alias{est_con_multinominal_c}
\title{Estimating log likelihood in Condition Stage}
\usage{
est_con_multinominal_c(
  observations,
  anchor,
  max_iter = 500000L,
  step_size = 1e-04,
  cr_rel_change = 1e-12,
  n_random_starts = 10L,
  trace = FALSE
)
}
\arguments{
\item{observations}{\code{NumericVector} containing the frequency of the
categories.}

\item{anchor}{\code{Integer} ranging between 1 and the number of categories.
Anchor defines the reference category. That is the category with the highest
probability according to the assumption of weak superiority.}

\item{max_iter}{\code{Integer} specifying the maximal number of iterations
for each random start.}

\item{step_size}{\code{Double} for specifying the size for increasing or
decreasing the probabilities during the estimation. This value should not
be less than 1e-3.}

\item{cr_rel_change}{\code{Double} for defining when the estimation should
stop. That is, if the change in log-likelihood is smaller as this value the
estimation stops.}

\item{n_random_starts}{\code{Integer} for the number of random start.}

\item{trace}{\code{Bool} \code{TRUE} if information about the progress of
estimation should be printed to the console. \code{FALSE} if not desired.}
}
\value{
Returns the log likelihood as a single numeric value.
}
\description{
Function written in \code{C++} estimating the log likelihood of a given
parameter set during the condition stage.
}
\references{
Berding, Florian, and Pargmann, Julia (2022).Iota Reliability Concept
of the Second Generation.Measures for Content Analysis Done by
Humans or Artificial Intelligences. Berlin: Logos.
https://doi.org/10.30819/5581
}
