% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_repr.R
\name{ip_to_bytes}
\alias{ip_to_bytes}
\alias{bytes_to_ip}
\title{Represent address as raw bytes}
\usage{
ip_to_bytes(x)

bytes_to_ip(x)
}
\arguments{
\item{x}{\itemize{
\item For \code{ip_to_bytes()}: An \code{\link{ip_address}} vector
\item For \code{bytes_to_ip()}: A \code{\link[blob:blob]{blob::blob}} vector
}}
}
\value{
\itemize{
\item For \code{ip_to_bytes()}: A \code{\link[blob:blob]{blob::blob}} vector
\item For \code{bytes_to_ip()}: An \code{\link{ip_address}} vector
}
}
\description{
Encode or decode an \code{\link{ip_address}} as a vector of raw bytes.
}
\details{
The bytes are stored in network order (also known as
big-endian order), which is part of the IP standard.

IPv4 addresses use 4 bytes, IPv6 addresses use 16 bytes,
and missing values are encoded as \code{NULL}.
}
\examples{
x <- ip_address(c("192.168.0.1", "2001:db8::8a2e:370:7334", NA))
ip_to_bytes(x)

bytes_to_ip(ip_to_bytes(x))
}
\seealso{
\itemize{
\item \code{\link[=ip_to_integer]{ip_to_integer()}} and \code{\link[=integer_to_ip]{integer_to_ip()}}
\item \code{\link[=ip_to_binary]{ip_to_binary()}} and \code{\link[=binary_to_ip]{binary_to_ip()}}
}
}
