% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ip_to_hostname.R
\name{ip_to_hostname}
\alias{ip_to_hostname}
\alias{hostname_to_ip}
\title{Translate address to/from hostname}
\usage{
ip_to_hostname(x, multiple = FALSE)

hostname_to_ip(x, multiple = FALSE)
}
\arguments{
\item{x}{\itemize{
\item For \code{ip_to_hostname()}: An \code{\link{ip_address}} vector
\item For \code{hostname_to_ip()}: A character vector of hostnames
}}

\item{multiple}{A logical scalar indicating if \emph{all} resolved endpoints are
returned, or just the first endpoint (the default). This determines whether
a vector or list of vectors is returned.}
}
\value{
\itemize{
\item For \code{ip_to_hostname()}: A character vector (\code{multiple = FALSE}) or
a list of character vectors (\code{multiple = TRUE})
\item For \code{hostname_to_ip()}: A \code{\link{ip_address}} vector (\code{multiple = FALSE}) or
a list of \code{\link{ip_address}} vectors (\code{multiple = TRUE})
}
}
\description{
Perform reverse and forward DNS resolution.

\strong{Note:} These functions are significantly slower than others in the
ipaddress package.
}
\details{
These functions require an internet connection. Before processing the input
vector, we first check that a known hostname can be resolved. If this fails,
an error is raised.

If DNS lookup cannot resolve an input, then \code{NA} is returned for that input.
If an error occurs during DNS lookup, then a warning is emitted and \code{NA} is
returned for that input.

DNS resolution performs a many-to-many mapping between IP addresses and
hostnames. For this reason, these two functions can potentially return
multiple values for each element of the input vector. The \code{multiple} argument
control whether \emph{all} values are returned (a vector for each input), or
just the first value (a scalar for each input).
}
\examples{
\dontrun{
hostname_to_ip("r-project.org")

ip_to_hostname(hostname_to_ip("r-project.org"))
}
}
\seealso{
The base function \code{nsl()} provides forward DNS resolution to IPv4 addresses,
but only on Unix-like systems.
}
