% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_mask.R
\name{netmask}
\alias{netmask}
\alias{prefix_length}
\alias{netmask.numeric}
\alias{hostmask}
\alias{hostmask.numeric}
\title{Network mask}
\usage{
prefix_length(x)

netmask(x, ...)

\method{netmask}{numeric}(x, is_ipv6 = NULL, ...)

hostmask(x, ...)

\method{hostmask}{numeric}(x, is_ipv6 = NULL, ...)
}
\arguments{
\item{x}{\itemize{
\item An \code{\link{ip_network}} vector.
\item An \code{\link{ip_interface}} vector.
\item \code{prefix_length()}: An \code{\link{ip_address}} vector of netmasks and/or hostmasks. Ambiguous cases
(all zeros, all ones) are treated as netmasks.
\item \code{netmask()} and \code{hostmask()}: An integer vector of prefix lengths.
}}

\item{...}{Arguments passed to methods.}

\item{is_ipv6}{A logical vector indicating whether to construct an IPv4 or
IPv6 address. If \code{NULL} (the default), then IPv4 is preferred but an IPv6
address is constructed when \code{x} is too large for the IPv4 address space.}
}
\value{
\itemize{
\item \code{prefix_length()}: An integer vector
\item \code{netmask()}: An \code{\link{ip_address}} vector
\item \code{hostmask()}: An \code{\link{ip_address}} vector
}
}
\description{
\code{prefix_length()}, \code{netmask()} and \code{hostmask()} extract different (but
equivalent) representations of the network mask. They accept an
\code{\link{ip_network}} or \code{\link{ip_interface}} vector.

The functions can also convert between these alternative representations.
For example, \code{prefix_length()} can infer the prefix length from an
\code{\link{ip_address}} vector of netmasks and/or hostmasks, while \code{netmask()} and
\code{hostmask()} can accept a vector of prefix lengths.
}
\examples{
x <- ip_network(c("192.168.0.0/22", "2001:db00::0/26"))

prefix_length(x)

netmask(x)

hostmask(x)

# construct netmask/hostmask from prefix length
netmask(c(22L, 26L), c(FALSE, TRUE))

hostmask(c(22L, 26L), c(FALSE, TRUE))

# extract prefix length from netmask/hostmask
prefix_length(ip_address(c("255.255.255.0", "0.255.255.255")))

# invalid netmask/hostmask raise a warning and return NA
prefix_length(ip_address("255.255.255.1"))
}
\seealso{
\code{\link[=max_prefix_length]{max_prefix_length()}}
}
