% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_survey_data.R
\name{get_survey_data}
\alias{get_survey_data}
\title{get_survey_data}
\usage{
get_survey_data(survey_id)
}
\arguments{
\item{survey_id}{ID of the survey from which the collected data shall be
extracted.
6-digit integer.}
}
\value{
A `data.frame` object containing the survey data.
Column names follow a dot-based naming scheme:
<group title>.<subquestion title>.
}
\description{
Get collected data from a specific survey on the connected
`LimeSurvey` instance.
Fails horribly saying
```
Error in make.names(col.names, unique = TRUE) :
invalid multibyte string 1
```
if data is empty.
}
\examples{
# This example assumes a locally hosted `LimeSurvey` instance using a locally
# hosted MySQL server.
# On this `LimeSurvey` instance, there is a survey with the ID 123456.
\dontrun{
connect_to_limesurvey(
  api_url = 'https://localhost/index.php/admin/remotecontrol',
  limesurvey_username = 'admin',
  limesurvey_password = '1234admin',
  mysql_host = '127.0.0.1',
  mysql_port = 3306,
  mysql_dbname = 'limesurvey',
  mysql_username = 'lime',
  mysql_password = '1234lime'
)

df_data <- get_survey_data(123456)
}

}
