% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_survey_id.R
\name{get_survey_id}
\alias{get_survey_id}
\title{get_survey_id}
\usage{
get_survey_id(survey_title)
}
\arguments{
\item{survey_title}{TItle of the survey. String.}
}
\value{
An integer Survey ID which can be used as a parameter in
`get_survey_data()`
}
\description{
Get numerical LimeSurvey ID of the survey with the given title.
}
\examples{
# This example assumes a locally hosted `LimeSurvey` instance using a locally
# hosted MySQL server.
# On this `LimeSurvey` instance, there is a survey with the title 'mysurvey'.
\dontrun{
connect_to_limesurvey(
  api_url = 'https://localhost/index.php/admin/remotecontrol',
  limesurvey_username = 'admin',
  limesurvey_password = '1234admin',
  mysql_host = '127.0.0.1',
  mysql_port = 3306,
  mysql_dbname = 'limesurvey',
  mysql_username = 'lime',
  mysql_password = '1234lime'
)

survey_id <- get_survey_id('mysurvey')
df_data <- get_survey_data(survey_id)
}

}
