% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{augment.ipd}
\alias{augment.ipd}
\title{Augment Data from an IPD Fit}
\usage{
\method{augment}{ipd}(x, data = x$data_u, ...)
}
\arguments{
\item{x}{An object of class \code{ipd}.}

\item{data}{The \code{data.frame} used to fit the model. Default is
\code{x$data}.}

\item{...}{Additional arguments to be passed to the augment function.}
}
\value{
A \code{data.frame} containing the original data along with fitted
values and residuals.
}
\description{
Augments the data used for an IPD method/model fit with additional
information about each observation.
}
\examples{

#-- Generate Example Data

set.seed(2023)

dat <- simdat(n = c(300, 300, 300), effect = 1, sigma_Y = 1)

head(dat)

formula <- Y - f ~ X1

#-- Fit IPD

fit <- ipd(formula, method = "postpi_analytic", model = "ols",

  data = dat, label = "set")

#-- Augment Data

augmented_df <- augment(fit)

head(augmented_df)

}
