% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipeadata_pkg.R
\name{ipeadata}
\alias{ipeadata}
\title{Returns a database about the requested series}
\usage{
ipeadata(code, language = c("en", "br"), quiet = FALSE)
}
\arguments{
\item{code}{A character vector with Ipeadata code.}

\item{language}{String specifying the selected language. Language options are
English (\code{"en"}, default) and Brazilian portuguese (\code{"br"}).}

\item{quiet}{Logical. If \code{FALSE} (default), a progress bar is shown.}
}
\value{
A data frame containing Ipeadata code, date, value, territorial unit name
and country or territorial code of requested series.
}
\description{
Returns a list with available database about the requested series.
}
\note{
The Ipeadata codes may be required by \code{available_series()}.
}
\examples{
\donttest{

# Data from
# "JPM366_EMBI366": J.P. Morgan Emerging Markets Bond Index (EMBI+), Brazil
# "SGS366_NASDAQ366": Nasdaq Composite Index - closed
data <- ipeadata(code = c("JPM366_EMBI366", "SGS366_NASDAQ366"))
# Data from
# "PRECOS12_IPCA12": Extended National Consumer Price Index (IPCA), Brazil
# in Brazilian portuguese
dataBR <- ipeadata(code = "PRECOS12_IPCA12", language = "br")
# Regional data from
# "CONSUMOTOT": Electric energy consumption, Brazil
dataReg <- ipeadata(code = "CONSUMOTOT")

}

}
\references{
This R package uses the Ipeadata API.
For more information go to \url{http://www.ipeadata.gov.br/}.
}
\seealso{
\code{\link{available_series}}, \code{\link{available_territories}}
}
