% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_pdf.R
\name{save_pdf}
\alias{save_pdf}
\title{Save the chart in PDF format}
\usage{
save_pdf(gplot, file.name, ...)
}
\arguments{
\item{gplot}{ggplot which will be saved.}

\item{file.name}{Character. Name of the file which will be generated}

\item{...}{Additional arguments to be passed to the \code{ggsave} function from the
\code{ggplot2} package.}
}
\value{
An \code{"PDF"} file
}
\description{
Convenient function to save charts in PDF format.
}
\examples{
\donttest{
# Creating theme for ggplot2 graph using default arguments
library(ggplot2)
fig_raw <- ggplot() +
  geom_col(data = mtcars, aes(x = hp , y = mpg, fill = cyl)) +
  theme_ipea()
# Save ggplot output
save_pdf(fig_raw,file.name = paste0(tempdir(),"/figura.pdf"))
}
}
\seealso{
Other save: 
\code{\link{save_eps}()}
}
\concept{save}
