% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipft.R
\name{ipfPlotEst}
\alias{ipfPlotEst}
\title{Plots the estimated locations}
\usage{
ipfPlotEst(model, estimation, testloc = NULL, observations = c(1),
  reverseAxis = FALSE, showNeighbours = FALSE, showLabels = FALSE,
  xlab = NULL, ylab = NULL, title = "")
}
\arguments{
\item{model}{an ipfModel}

\item{estimation}{an ipfEstimation}

\item{testloc}{location of test observations}

\item{observations}{a numeric vector with the indices of estimations to plot}

\item{reverseAxis}{swaps axis}

\item{showNeighbours}{plot the k selected neighbours}

\item{showLabels}{shows labels}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{title}{plot title}
}
\description{
Plots the estimated locations
}
\examples{

    model <- ipfKnn(ipftrain[, 1:168], ipftest[, 1:168])
    estimation <- ipfEstimate(model, ipftrain[, 169:170], ipftest[, 169:170])
    ipfPlotEst(model, estimation, ipftest[, 169:170], observations = seq(7,10),
               showNeighbours = TRUE, reverseAxis = TRUE)

}

