% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipft.R
\name{ipfPlotEst}
\alias{ipfPlotEst}
\title{Plots the estimated locations}
\usage{
ipfPlotEst(model, estimation, testpos = NULL, observations = c(1),
  reverseAxis = FALSE, showneighbors = FALSE, showLabels = FALSE,
  xlab = NULL, ylab = NULL, title = "")
}
\arguments{
\item{model}{an ipfModel}

\item{estimation}{an ipfEstimation}

\item{testpos}{position of the test observations}

\item{observations}{a numeric vector with the indices of estimations to plot}

\item{reverseAxis}{swaps axis}

\item{showneighbors}{plot the k selected neighbors}

\item{showLabels}{shows labels}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{title}{plot title}
}
\description{
Plots the estimated locations
}
\examples{

    model      <- ipfKnn(ipftrain[, 1:168], ipftrain[, 169:170])
    estimation <- ipfEstimate(model, ipftest[, 1:168], ipftest[, 169:170])
    ipfPlotEst(model, estimation, ipftest[, 169:170], observations = seq(7,10),
               showneighbors = TRUE, reverseAxis = TRUE)

}
