% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_file.R
\name{download_file}
\alias{download_file}
\title{Download file from GitHub via the proxy site https://ghproxy.com}
\usage{
download_file(
  url,
  destfile,
  method,
  quiet = FALSE,
  mode = "w",
  cacheOK = TRUE,
  extra = getOption("download.file.extra"),
  headers = NULL
)
}
\arguments{
\item{url}{a character string (or longer vector for the "libcurl" method) 
naming the URL of a resource to be downloaded.}

\item{destfile}{a character string (or vector, see the url argument) 
with the file path where the downloaded file is to be saved. 
Tilde-expansion is performed.}

\item{method}{Method to be used for downloading files. Current download 
methods are "internal", "libcurl", "wget", "curl" and "wininet" (Windows only), 
and there is a value "auto": see ‘Details’ and ‘Note’. The method can also 
be set through the option "download.file.method": see options().}

\item{quiet}{If TRUE, suppress status messages (if any), and the progress bar.}

\item{mode}{character. The mode with which to write the file. Useful values 
are "w", "wb" (binary), "a" (append) and "ab". Not used for methods "wget" and 
"curl". See also ‘Details’, notably about using "wb" for Windows.}

\item{cacheOK}{logical. Is a server-side cached value acceptable?}

\item{extra}{character vector of additional command-line arguments for the 
"wget" and "curl" methods.}

\item{headers}{named character vector of additional HTTP headers to use in 
HTTP[S] requests. It is ignored for non-HTTP[S] URLs. The User-Agent header 
taken from the HTTPUserAgent option (see options) is automatically used as 
the first header.}
}
\description{
This function can be used to download a file from GitHub via the 
proxy site https://ghproxy.com.
}
\examples{

# Example(Not run)
# download_file(
#  url = "https://github.com/hadley/mastering-shiny/raw/main/neiss/products.tsv",
#  destfile = "products.tsv",
#  quiet = TRUE
# )

}
