/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Vector;
import org.rosuda.ibase.Commander;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.Dependent;
import org.rosuda.ibase.Notifier;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.toolkit.Axis;
import org.rosuda.ibase.toolkit.Platform;
import org.rosuda.ibase.toolkit.PlotComponent;
import org.rosuda.ibase.toolkit.PlotManager;
import org.rosuda.pograss.PoGraSS;
import org.rosuda.pograss.PoGraSSPDF;
import org.rosuda.pograss.PoGraSSPS;
import org.rosuda.pograss.PoGraSSgraphics;
import org.rosuda.pograss.PoGraSSmeta;
import org.rosuda.util.Global;
import org.rosuda.util.MsgDialog;
import org.rosuda.util.PngEncoder;
import org.rosuda.util.SpacingPanel;
import org.rosuda.util.Tools;

public class PGSCanvas
extends PlotComponent
implements Commander,
Dependent,
Printable {
    static final String LBL_OK = "OK";
    static final String str2 = "Cancel";
    protected Frame myFrame = null;
    protected String desc = "untitled PGS canvas";
    static Notifier globalNotifier = null;
    protected PlotManager pm = new PlotManager(this);
    protected boolean inProgress = false;
    protected Axis ax;
    protected Axis ay;
    protected boolean cancel;
    protected Dialog intDlg;
    public PageFormat pageFormat;
    protected int paintLayerCounter;

    public PGSCanvas(int n, int n2, Axis axis, Axis axis2) {
        this(n, n2);
        this.ax = axis;
        this.ay = axis2;
    }

    public PGSCanvas(int n, int n2) {
        super(n, n2);
        if (globalNotifier == null) {
            globalNotifier = new Notifier();
        }
        globalNotifier.addDepend(this);
    }

    public PGSCanvas(int n) {
        this(-1, n);
    }

    public PGSCanvas() {
        this(-1, 1);
    }

    protected void finalize() {
        globalNotifier.delDepend(this);
    }

    public static Notifier getGlobalNotifier() {
        if (globalNotifier == null) {
            globalNotifier = new Notifier();
        }
        return globalNotifier;
    }

    public void paintLayer(Graphics graphics, int n) {
        if (this.inProgress) {
            return;
        }
        this.inProgress = true;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (Global.forceAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        PoGraSSgraphics poGraSSgraphics = new PoGraSSgraphics(graphics2D, n);
        this.beginPaint(poGraSSgraphics);
        this.paintPoGraSS(poGraSSgraphics);
        this.endPaint(poGraSSgraphics);
        this.inProgress = false;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n >= 1) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.paintLayer(graphics, -1);
        return 0;
    }

    public void setFrame(Frame frame) {
        this.myFrame = frame;
    }

    public Frame getFrame() {
        return this.myFrame;
    }

    public void setTitle(String string) {
        this.desc = string;
        this.myFrame.setTitle(this.desc);
    }

    public String getTitle() {
        return this.desc;
    }

    public void paintPoGraSS(PoGraSS poGraSS) {
    }

    public PlotManager getPlotManager() {
        return this.pm;
    }

    public Axis getXAxis() {
        return this.ax;
    }

    public Axis getYAxis() {
        return this.ay;
    }

    public SVar getData(int n) {
        return null;
    }

    protected void nextLayer(PoGraSS poGraSS) {
        if (this.pm != null) {
            this.pm.drawLayer(poGraSS, this.paintLayerCounter, this.layers);
        }
        ++this.paintLayerCounter;
        poGraSS.nextLayer();
    }

    protected void beginPaint(PoGraSS poGraSS) {
        this.paintLayerCounter = 0;
    }

    protected void endPaint(PoGraSS poGraSS) {
        while (this.paintLayerCounter < this.layers) {
            this.nextLayer(poGraSS);
        }
    }

    public void forcedFlush() {
        Rectangle rectangle = this.getBounds();
        this.setUpdateRoot(0);
        this.setSize(rectangle.width, rectangle.height);
    }

    public Object run(Object object, String string) {
        Object object2;
        Panel panel;
        Button button;
        Object object3;
        Object object4;
        Object object5;
        if ("BREAK".equals(string) && Common.breakDispatcher != null) {
            Common.breakDispatcher.NotifyAll(new NotifyMsg(this, 0x700000));
        }
        if ("prefs".equals(string)) {
            Platform.getPlatform().handlePrefs();
        }
        if ("exportPGS".equals(string)) {
            object5 = new PoGraSSmeta();
            this.paintPoGraSS((PoGraSS)object5);
            this.endPaint((PoGraSS)object5);
            object4 = Tools.getNewOutputStreamDlg(this.myFrame, "Export as PoGraSS to ...", "output.pgs");
            if (object4 != null) {
                ((PrintStream)object4).print(((PoGraSSmeta)object5).getMeta());
                ((PrintStream)object4).close();
            }
        }
        if ("exportPS".equals(string) && (object5 = Tools.getNewOutputStreamDlg(this.myFrame, "Export as PostScript to ...", "output.ps")) != null) {
            object4 = new PoGraSSPS((PrintStream)object5);
            ((PoGraSSPS)object4).setTitle(this.desc);
            this.beginPaint((PoGraSS)object4);
            this.paintPoGraSS((PoGraSS)object4);
            this.endPaint((PoGraSS)object4);
            ((PrintStream)object5).close();
        }
        if ("exportPDF".equals(string)) {
            new MsgDialog(this.myFrame, "Information", "Please note that the PDF export is very experimental. If the result is unsatisfactory, please use the PostScript export instead.");
            object5 = Tools.getNewOutputStreamDlg(this.myFrame, "Export as PDF to ...", "output.pdf");
            if (object5 != null) {
                object4 = new PoGraSSPDF((PrintStream)object5);
                ((PoGraSSPDF)object4).setTitle(this.desc);
                this.beginPaint((PoGraSS)object4);
                this.paintPoGraSS((PoGraSS)object4);
                this.endPaint((PoGraSS)object4);
                ((PrintStream)object5).close();
            }
        }
        if ("sizeDlg".equals(string)) {
            this.intDlg = new Dialog(this.myFrame, "Set plot size", true);
            object5 = this.intDlg;
            ((Dialog)object5).setBackground(Color.white);
            ((Container)object5).setLayout(new BorderLayout());
            ((Container)object5).add((Component)new SpacingPanel(), "West");
            ((Container)object5).add((Component)new SpacingPanel(), "East");
            object4 = new Panel();
            ((Container)object4).setLayout(new FlowLayout());
            object3 = new Button(LBL_OK);
            ((Container)object4).add((Component)object3);
            button = new Button(str2);
            ((Container)object4).add(button);
            ((Container)object5).add((Component)object4, "South");
            ((Container)object5).add((Component)new Label(" "), "North");
            panel = new Panel();
            panel.setLayout(new FlowLayout());
            ((Container)object5).add(panel);
            panel.add(new Label("width: "));
            TextField textField = new TextField("" + this.getSize().width, 6);
            TextField textField2 = new TextField("" + this.getSize().height, 6);
            panel.add(textField);
            panel.add(new Label(", height: "));
            panel.add(textField2);
            ((Window)object5).pack();
            object2 = new IDlgCL(this);
            ((Button)object3).addActionListener((ActionListener)object2);
            button.addActionListener((ActionListener)object2);
            ((Dialog)object5).setVisible(true);
            if (!this.cancel) {
                int n = Tools.parseInt(textField.getText());
                int n2 = Tools.parseInt(textField2.getText());
                if (n < 10) {
                    n = this.getSize().width;
                }
                if (n2 < 10) {
                    n = this.getSize().height;
                }
                this.setSize(n, n2);
                if (this.myFrame != null) {
                    this.myFrame.pack();
                }
            }
            ((Window)object5).dispose();
        }
        if ("javaPrint".equals(string)) {
            object5 = PrinterJob.getPrinterJob();
            if (this.pageFormat == null) {
                this.pageFormat = ((PrinterJob)object5).defaultPage();
            }
            ((PrinterJob)object5).setPrintable(this, this.pageFormat);
            if (((PrinterJob)object5).printDialog()) {
                try {
                    ((PrinterJob)object5).print();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if ("pageSetup".equals(string)) {
            object5 = PrinterJob.getPrinterJob();
            if (this.pageFormat == null) {
                this.pageFormat = ((PrinterJob)object5).defaultPage();
            }
            this.pageFormat = ((PrinterJob)object5).pageDialog(this.pageFormat);
        }
        if ("exportBitmapDlg".equals(string)) {
            this.intDlg = new Dialog(this.myFrame, "Export as bitmap with size", true);
            object5 = this.intDlg;
            ((Dialog)object5).setBackground(Color.white);
            ((Container)object5).setLayout(new BorderLayout());
            ((Container)object5).add((Component)new SpacingPanel(), "West");
            ((Container)object5).add((Component)new SpacingPanel(), "East");
            object4 = new Panel();
            ((Container)object4).setLayout(new FlowLayout());
            object3 = new Button(LBL_OK);
            ((Container)object4).add((Component)object3);
            button = new Button(str2);
            ((Container)object4).add(button);
            ((Container)object5).add((Component)object4, "South");
            ((Container)object5).add((Component)new Label(" "), "North");
            panel = new Panel();
            panel.setLayout(new FlowLayout());
            ((Container)object5).add(panel);
            panel.add(new Label("width: "));
            int n = this.getSize().width;
            int n3 = this.getSize().height;
            object2 = new TextField("" + n, 6);
            TextField textField = new TextField("" + n3, 6);
            panel.add((Component)object2);
            panel.add(new Label(", height: "));
            panel.add(textField);
            panel.add(new Label(", font size: "));
            TextField textField3 = new TextField("10", 6);
            panel.add(textField3);
            ((Window)object5).pack();
            IDlgCL iDlgCL = new IDlgCL(this);
            ((Button)object3).addActionListener(iDlgCL);
            button.addActionListener(iDlgCL);
            ((Dialog)object5).setVisible(true);
            if (!this.cancel) {
                int n4 = Tools.parseInt(((TextComponent)object2).getText());
                int n5 = Tools.parseInt(textField.getText());
                double d = Tools.parseDouble(textField3.getText());
                if (n4 < 10) {
                    n4 = this.getSize().width;
                }
                if (n5 < 10) {
                    n4 = this.getSize().height;
                }
                this.setSize(n4, n5);
                BufferedImage bufferedImage = new BufferedImage(n4, n5, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                PoGraSSgraphics poGraSSgraphics = new PoGraSSgraphics(graphics2D);
                poGraSSgraphics.setTitle(this.desc);
                this.beginPaint(poGraSSgraphics);
                poGraSSgraphics.setFontSize(d);
                this.paintPoGraSS(poGraSSgraphics);
                this.endPaint(poGraSSgraphics);
                this.setSize(n, n3);
                FileDialog fileDialog = new FileDialog(this.myFrame, this.desc, 1);
                fileDialog.setModal(true);
                fileDialog.show();
                String string2 = "";
                if (fileDialog.getDirectory() != null) {
                    string2 = string2 + fileDialog.getDirectory();
                }
                if (fileDialog.getFile() != null) {
                    string2 = string2 + fileDialog.getFile();
                }
                if (!PngEncoder.savePNG(new File(string2), new PngEncoder(bufferedImage, true, 0, 7))) {
                    System.err.println("PGSCanvas.run.exportBitmapDlg: Unable to write PNG file \"" + string2 + "\"");
                }
            }
            ((Window)object5).dispose();
        }
        if ("exportSVG".equals(string)) {
            boolean bl = false;
            object4 = null;
            try {
                object3 = Class.forName("PoGraSSSVG");
                object4 = (PoGraSS)((Class)object3).newInstance();
                bl = true;
            }
            catch (Throwable throwable) {
                System.out.println("Cannot load SVG classes: " + throwable.getMessage());
                throwable.printStackTrace();
            }
            if (bl) {
                object3 = Tools.getNewOutputStreamDlg(this.myFrame, "Export as SVG to ...", "output.svg");
                if (object3 != null) {
                    ((PoGraSS)object4).setOutPrintStream((PrintStream)object3);
                    ((PoGraSS)object4).setTitle(this.desc);
                    this.beginPaint((PoGraSS)object4);
                    this.paintPoGraSS((PoGraSS)object4);
                    this.endPaint((PoGraSS)object4);
                    ((PrintStream)object3).close();
                }
            } else {
                new MsgDialog(this.myFrame, "PGS Export", "Cannot find SVG-extensions. Please make sure that PoGraSSSVG is properly installed.").show();
            }
        }
        return null;
    }

    public void Notifying(NotifyMsg notifyMsg, Object object, Vector vector) {
        if (this.myFrame != null) {
            this.myFrame.setBackground(Common.backgroundColor);
        }
        this.setBackground(Common.backgroundColor);
        this.setUpdateRoot(0);
        this.repaint();
    }

    public void setOption(String string, boolean bl) {
        Field field = null;
        try {
            field = this.getClass().getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        if (field != null) {
            try {
                field.setBoolean(this, bl);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                this.invokeSetterMethod(string, Boolean.TYPE, bl);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println("Variable " + string + " does not exist or cannot be set.");
            }
        }
    }

    public void setOption(String string, int n) {
        if (!this.setOptionInt(string, n)) {
            System.err.println("Variable " + string + " does not exist or cannot be set.");
        }
    }

    public void setOption(String string, int[] nArray) {
        if (!this.setOptionInts(string, nArray)) {
            System.err.println("Variable " + string + " does not exist or cannot be set.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOption(String string, double[] dArray) {
        Field field = null;
        try {
            field = this.getClass().getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        if (field != null) {
            try {
                field.set(this, dArray);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                int[] nArray = new int[dArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = (int)(dArray[i] + 0.5);
                }
                if (!this.setOptionInts(string, nArray)) return;
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        try {
            this.invokeSetterMethod(string, Class.forName("[D"), dArray);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                int[] nArray = new int[dArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = (int)(dArray[i] + 0.5);
                }
                this.invokeSetterMethod(string, Class.forName("[I"), nArray);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                System.err.println("Variable " + string + " does not exist or cannot be set.");
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOption(String string, double d) {
        Field field = null;
        try {
            field = this.getClass().getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        if (field != null) {
            try {
                field.setDouble(this, d);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (d - (double)((int)d) != 0.0 || !this.setOptionInt(string, (int)d)) return;
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        try {
            this.invokeSetterMethod(string, Double.TYPE, new Double(d));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (d - (double)((int)d) == 0.0) {
                try {
                    this.invokeSetterMethod(string, Integer.TYPE, new Integer((int)d));
                    return;
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    System.err.println("Variable " + string + " does not exist or cannot be set.");
                }
            }
            System.err.println("Variable " + string + " does not exist or cannot be set.");
        }
    }

    public void setOption(String string, String string2) {
        Field field = null;
        try {
            field = this.getClass().getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        if (field != null) {
            Object object = string2;
            if (Color.class.isAssignableFrom(field.getType())) {
                object = this.getColorForString(string2);
            }
            if (object != null) {
                try {
                    field.set(this, object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else {
            try {
                this.invokeSetterMethod(string, string2.getClass(), string2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println("Variable " + string + " does not exist or cannot be set.");
            }
        }
    }

    private void invokeSetterMethod(String string, Class clazz, Object object) throws NoSuchMethodException {
        Method method = null;
        Object object2 = object;
        String string2 = "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
        try {
            method = this.getClass().getMethod(string2, clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (String.class.isAssignableFrom(clazz)) {
                method = this.getClass().getMethod(string2, Color.class);
                object2 = this.getColorForString((String)object);
                if (object2 == null) {
                    return;
                }
            }
            throw noSuchMethodException;
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        if (method == null) {
            throw new NoSuchMethodException("There is no setter method for " + string);
        }
        try {
            method.invoke((Object)this, object2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean setOptionInt(String string, int n) {
        Field field = null;
        try {
            field = this.getClass().getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            return false;
        }
        if (field != null) {
            try {
                field.setInt(this, n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        try {
            this.invokeSetterMethod(string, Integer.TYPE, new Integer(n));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("Variable " + string + " does not exist or cannot be set.");
            return false;
        }
        return true;
    }

    private Color getColorForString(String string) {
        Color color = null;
        if (string.startsWith("#")) {
            Color color2 = Color.decode(string.substring(0, 7));
            color = string.length() > 7 ? new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), Integer.parseInt(string.substring(7, 9), 16)) : color2;
        } else {
            try {
                Field field = Color.class.getField(string);
                color = (Color)field.get(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                System.err.println("There is no predefined color named " + string + ".");
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        return color;
    }

    private boolean setOptionInts(String string, int[] nArray) {
        Field field = null;
        try {
            field = this.getClass().getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            return false;
        }
        if (field != null) {
            try {
                field.set(this, nArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        try {
            this.invokeSetterMethod(string, Class.forName("[I"), nArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("Variable " + string + " does not exist or cannot be set.");
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return true;
    }

    public class IDlgCL
    implements ActionListener {
        PGSCanvas c;

        public IDlgCL(PGSCanvas pGSCanvas2) {
            this.c = pGSCanvas2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.c.cancel = !PGSCanvas.LBL_OK.equals(actionEvent.getActionCommand());
            this.c.intDlg.setVisible(false);
        }
    }
}

