% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/long_to_wide_converter.R
\name{long_to_wide_converter}
\alias{long_to_wide_converter}
\title{Converts dataframe from long/tidy to wide format with \code{NA}s removed}
\usage{
long_to_wide_converter(
  data,
  x,
  y,
  subject.id = NULL,
  paired = TRUE,
  spread = TRUE,
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{subject.id}{In case of repeated measures design (\code{paired = TRUE},
i.e.), this argument specifies the subject or repeated measures id. Note
that if this argument is \code{NULL} (which is the default), the function
assumes that the data has already been sorted by such an id by the user and
creates an internal identifier. So if your data is \strong{not} sorted and you
leave this argument unspecified, the results can be inaccurate.}

\item{paired}{Logical that decides whether the experimental design is
repeated measures/within-subjects or between-subjects. The default is
\code{FALSE}.}

\item{spread}{Logical that decides whether the dataframe needs to be
converted from long/tidy to wide (default: \code{TRUE}), or the data needs to be
returned as it is but with the \code{NA}s removed.}

\item{...}{Currently ignored.}
}
\value{
A dataframe in the wide (or Cartesian) format.
}
\description{
This conversion is helpful mostly for repeated measures design.
}
\examples{
# for reproducibility
library(ipmisc)
set.seed(123)

# repeated measures design
long_to_wide_converter(
  data = bugs_long,
  x = condition,
  y = desire,
  subject.id = subject,
  paired = TRUE
)

# independent measures design
long_to_wide_converter(
  data = ggplot2::msleep,
  x = vore,
  y = brainwt,
  paired = FALSE,
  spread = FALSE
)
}
