% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-export.R
\name{domains}
\alias{domains}
\alias{domains.proto_ipm}
\alias{domains.default}
\alias{vital_rate_exprs}
\alias{vital_rate_exprs.proto_ipm}
\alias{vital_rate_exprs.default}
\alias{vital_rate_funs}
\alias{vital_rate_exprs<-}
\alias{vital_rate_exprs<-.proto_ipm}
\alias{new_fun_form}
\alias{kernel_formulae}
\alias{kernel_formulae.proto_ipm}
\alias{kernel_formulae.default}
\alias{kernel_formulae<-}
\alias{kernel_formulae<-.proto_ipm}
\alias{parameters}
\alias{parameters.proto_ipm}
\alias{parameters.default}
\alias{parameters<-}
\alias{parameters<-.proto_ipm}
\alias{int_mesh}
\alias{pop_state}
\alias{pop_state.proto_ipm}
\alias{pop_state.default}
\title{Accessor functions for (proto_)ipm objects}
\usage{
domains(object)

\method{domains}{proto_ipm}(object)

\method{domains}{default}(object)

vital_rate_exprs(object)

\method{vital_rate_exprs}{proto_ipm}(object)

\method{vital_rate_exprs}{default}(object)

vital_rate_funs(ipm)

vital_rate_exprs(object, kernel, vital_rate) <- value

\method{vital_rate_exprs}{proto_ipm}(object, kernel, vital_rate) <- value

new_fun_form(form)

kernel_formulae(object)

\method{kernel_formulae}{proto_ipm}(object)

\method{kernel_formulae}{default}(object)

kernel_formulae(object, kernel) <- value

\method{kernel_formulae}{proto_ipm}(object, kernel) <- value

parameters(object)

\method{parameters}{proto_ipm}(object)

\method{parameters}{default}(object)

parameters(object) <- value

\method{parameters}{proto_ipm}(object) <- value

int_mesh(ipm, full_mesh = TRUE)

pop_state(object)

\method{pop_state}{proto_ipm}(object)

\method{pop_state}{default}(object)
}
\arguments{
\item{object}{A \code{proto_ipm} or object created by \code{make_ipm()}.}

\item{ipm}{An object created by \code{make_ipm()}. This argument only applies to
\code{int_mesh()} and \code{vital_rate_funs()} (because these are not built
until \code{make_ipm()} is called).}

\item{kernel}{The name of the kernel to insert the new vital rate expression
into.}

\item{vital_rate}{The name of the vital rate to replace. If the vital rate
doesn't already exist in the \code{object}, a new one with this name will be
created.}

\item{value}{For \code{parameters<-}, a named list of new parameters. The new list does not need
to contain all of the parameters, just the ones to update/append. For
\code{vital_rate_exprs<-} and \code{kernel_formulae<-}, a new functional form.
The new functional form must be wrapped in a call to \code{new_fun_form}.}

\item{form}{An expression representing the new vital rate or kernel formula
to insert.}

\item{full_mesh}{Return the full integration mesh? Default is \code{TRUE}.
\code{FALSE} returns only unique values for each state variable.}
}
\value{
Depending on the class of \code{object}, a list
with types numeric or character.
}
\description{
Functions that access slots of a \code{*_ipm} (including
 \code{proto_ipm}). \code{default} methods correspond to \code{*_ipm} objects.
}
\details{
The \code{*.default} method corresponds to output from \code{make_ipm()},
and the \code{*.proto_ipm} methods correspond to outputs from \code{define_*}.

When using \code{kernel_formulae<-} and \code{vital_rates_exprs<-}, the right
hand side of the expression must be wrapped in \code{new_fun_form}. See
examples.

Note that when using \code{vital_rate_funs}, unless the vital rate expression
explicitly contains an expression for integration, these functions
\strong{are not yet integrated!} This is useful for things like sensitivity
and elasticity analysis, but care must be taken to not use these values
incorrectly.
}
\examples{

data(gen_di_det_ex)

proto <- gen_di_det_ex$proto_ipm

# Create a new, iterated IPM
new_ipm <- make_ipm(proto, iterate = TRUE,
                    iterations = 100, return_all_envs = TRUE)

vital_rate_exprs(new_ipm)
kernel_formulae(new_ipm)
vital_rate_funs(new_ipm)

domains(new_ipm)
parameters(new_ipm)

# Usage is the same for proto_ipm's as *_ipm's

vital_rate_exprs(proto)
kernel_formulae(proto)

domains(proto)
parameters(proto)

int_mesh(new_ipm)

# Setting new parameters, vital rate expressions, and kernel formulae
# only works on proto_ipm's.

# This replaces the "g_int" parameter and leaves the rest untouched

parameters(proto) <- list(g_int = 1.5)

# This creates a new g_z parameter and leaves the rest of parameters untouched
parameters(proto) <- list(g_z = 2.2)

# setting a new vital rate or kernel expression requires wrapping the
# right-hand side in a call to new_fun_form(). new_fun_form uses expressions
# with the same format as ... in define_kernel()

vital_rate_exprs(proto,
                 kernel = "P",
                 vital_rate = "g_mu") <- new_fun_form(g_int + g_z + g_slope * ht_1)

kernel_formulae(proto, kernel = "stay_discrete") <- new_fun_form(g_z * d_ht)

}
