% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\name{gen_smooth}
\alias{gen_smooth}
\title{Generate simulated data for smoothing models}
\usage{
gen_smooth(n = 150, xlim = c(0.2, 4.6), x.jitter = 0.65,
  seed = NULL)
}
\arguments{
\item{n}{Sample size.}

\item{xlim}{Limits of the \code{X} variables to generate from.}

\item{x.jitter}{A small amount of jitter is added to the \code{X} variables
generated from a normal distribution with mean zero and standard deviation
equal to \code{x.jitter}.}

\item{seed}{(Optional) Random seed.}
}
\value{
A dataframe containing the response variable \code{y} and
  unidimensional explanatory variable \code{X}.
}
\description{
Generate simulated data for smoothing models
}
\examples{
gen_smooth(10)

}
