% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_files.r
\name{ipums_list_files}
\alias{ipums_list_files}
\alias{ipums_list_data}
\alias{ipums_list_shape}
\alias{ipums_list_raster}
\title{List files available for analysis in an IPUMS extract}
\usage{
ipums_list_files(file, types = NULL, data_layer = NULL,
  shape_layer = NULL, raster_layer = NULL)

ipums_list_data(file, data_layer = NULL)

ipums_list_shape(file, shape_layer = NULL)

ipums_list_raster(file, raster_layer = NULL)
}
\arguments{
\item{file}{An IPUMS extract zip file or directory}

\item{types}{One or more of "data", "shape", or "raster" indicating
what type of files to look for.}

\item{data_layer}{dplyr \code{\link[dplyr]{select}}-style notation for the data
files to look for}

\item{shape_layer}{dplyr \code{\link[dplyr]{select}}-style notation for the
shape files to look for}

\item{raster_layer}{dplyr \code{\link[dplyr]{select}}-style notation for the
raster files to look for}
}
\value{
A \code{tbl_df} data.frame containing the files available
}
\description{
Find which files can be loaded from an IPUMS extract. On Windows,
this is generally a zip file (which you can optionally unzip). On
macOS, they are generally unzipped for you, so there will be a
directory.
}
\examples{
nhgis_file <- ipums_example("nhgis0008_csv.zip")
ipums_list_files(nhgis_file) # Only one extract available

}
