% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lbl_helpers.r
\name{lbl_na_if}
\alias{lbl_na_if}
\title{Set labelled values to missing}
\usage{
lbl_na_if(x, .predicate)
}
\arguments{
\item{x}{A \code{\link[haven]{labelled}} vector}

\item{.predicate}{A function that takes .val and .lbl (the values and
labels) and returns TRUE or FALSE. It is passed to a function similar
to \code{\link[rlang]{as_function}}, so also accepts quosure-style lambda
functions (that use values .val and .lbl). See examples for more information.}
}
\value{
A haven::labelled vector
}
\description{
Convert values to NA based on their label and value in a
\code{\link[haven]{labelled}} vector. Ignores any value that does not have a
label.
}
\examples{
x <- haven::labelled(
  c(10, 10, 11, 20, 30, 99, 30, 10),
  c(Yes = 10, `Yes - Logically Assigned` = 11, No = 20, Maybe = 30, NIU = 99)
)

lbl_na_if(x, ~.val >= 90)
lbl_na_if(x, ~.lbl \%in\% c("Maybe"))
lbl_na_if(x, ~.val >= 90 | .lbl \%in\% c("Maybe"))

# You can also use the more explicit function notation
lbl_na_if(x, function(.val, .lbl) .val >= 90)

# Or even the name of a function
na_function <- function(.val, .lbl) .val >= 90
lbl_na_if(x, "na_function")

}
\seealso{
Other lbl_helpers: 
\code{\link{lbl_add}()},
\code{\link{lbl_clean}()},
\code{\link{lbl_collapse}()},
\code{\link{lbl_define}()},
\code{\link{lbl_relabel}()},
\code{\link{lbl}()},
\code{\link{zap_ipums_attributes}()}
}
\concept{lbl_helpers}
