% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_define_extract.R
\name{remove_from_extract}
\alias{remove_from_extract}
\title{Remove values from an existing IPUMS extract definition}
\usage{
remove_from_extract(extract, ...)
}
\arguments{
\item{extract}{An \code{\link[=ipums_extract-class]{ipums_extract}} object.}

\item{...}{Additional arguments specifying the extract fields and values to
remove from the extract definition.}
}
\value{
An object of the same class as \code{extract} containing the modified
extract definition
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Remove values for specific fields in an existing \code{ipums_extract}
object. This function is an S3 generic whose behavior will depend on the
subclass (i.e. collection) of the extract being modified.
\itemize{
\item To remove from an \strong{IPUMS Microdata} extract definition, click
\link[=remove_from_extract.micro_extract]{here}. This includes:
\itemize{
\item IPUMS USA
\item IPUMS CPS
\item IPUMS International
}
\item To remove from an \strong{IPUMS NHGIS} extract definition, click
\link[=remove_from_extract.nhgis_extract]{here}
}

This function is marked as experimental because it is typically not the best
option for maintaining reproducible extract definitions and may be retired
in the future. For reproducibility, users should strive to build extract
definitions with \code{\link[=define_extract]{define_extract_*()}} functions.

If you have a complicated extract definition to revise, but do not have
the original extract definition code that created it, we suggest that you
save the revised extract as a JSON file with \code{\link[=save_extract_as_json]{save_extract_as_json()}}. This
will create a stable version of the extract definition that
can be used in the future as needed.

To add new values to an extract, see \code{\link[=add_to_extract]{add_to_extract()}}.

Learn more about the IPUMS API in \code{vignette("ipums-api")}.
}
\examples{
# Microdata extracts
usa_extract <- define_extract_usa(
  description = "USA example",
  samples = c("us2013a", "us2014a"),
  variables = list(
    var_spec("AGE"),
    var_spec("SEX", case_selections = "2"),
    var_spec("YEAR")
  )
)

# Remove variables from an extract definition
remove_from_extract(
  usa_extract,
  samples = "us2014a",
  variables = c("AGE", "SEX")
)

# Remove detailed specifications for an existing variable
remove_from_extract(
  usa_extract,
  variables = var_spec("SEX", case_selections = "2")
)

# NHGIS extracts
nhgis_extract <- define_extract_nhgis(
  datasets = ds_spec(
    "1990_STF1",
    data_tables = c("NP1", "NP2", "NP3"),
    geog_levels = "county"
  ),
  time_series_tables = tst_spec("A00", geog_levels = "county")
)

# Remove an existing dataset or time series table
remove_from_extract(nhgis_extract, datasets = "1990_STF1")

# Remove detailed specifications from an existing dataset or
# time series table
remove_from_extract(
  nhgis_extract,
  datasets = ds_spec("1990_STF1", data_tables = "NP1")
)
}
\seealso{
\code{\link[=add_to_extract]{add_to_extract()}} to add values to an extract definition.

\code{\link[=define_extract]{define_extract_*()}} to create a new extract definition
from scratch.

\code{\link[=submit_extract]{submit_extract()}} to submit an extract request for processing.
}
\keyword{internal}
