% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_define_extract.R
\name{ipums_extract-class}
\alias{ipums_extract-class}
\alias{ipums_extract}
\title{\code{ipums_extract} class}
\description{
The \code{ipums_extract} class provides a data structure for storing the
extract definition and status of an IPUMS data extract request. Both
submitted and unsubmitted extract requests are stored in \code{ipums_extract}
objects.

\code{ipums_extract} objects are further divided into microdata
and aggregate data classes, and will also include
a collection-specific extract subclass to accommodate differences in
extract options and content across collections.

Currently supported collections are:
\itemize{
\item IPUMS microdata (\code{"micro_extract"})
\itemize{
\item IPUMS USA (\code{"usa_extract"})
\item IPUMS CPS (\code{"cps_extract"})
\item IPUMS International (\code{"ipumsi_extract"})
}
\item IPUMS aggregate data (\code{"agg_extract"})
\itemize{
\item IPUMS NHGIS (\code{"nhgis_extract"})
}
}

Learn more about the IPUMS API in \code{vignette("ipums-api")}.
}
\section{Properties}{

Objects of class \code{ipums_extract} have:
\itemize{
\item A \code{class} attribute of the form
\code{c("{collection}_extract", "{collection_type}_extract", "ipums_extract")}.
For instance, \code{c("cps_extract", "micro_extract", "ipums_extract")}.
\item A base type of \code{"list"}.
\item A \code{names} attribute that is a character vector the same length as the
underlying list.
}

All \code{ipums_extract} objects will include several core fields identifying
the extract and its status:
\itemize{
\item \code{collection}: the collection for the extract request.
\item \code{description}: the description of the extract request.
\item \code{submitted}: logical indicating whether the extract request has been
submitted to the IPUMS API for processing.
\item \code{download_links}: links to the downloadable data, if the extract request
was completed at the time it was last checked.
\item \code{number}: the number of the extract request. With \code{collection}, this
uniquely identifies an extract request for a given user.
\item \code{status}: status of the extract request at the time it was last checked.
One of \code{"unsubmitted"}, \code{"queued"}, \code{"started"}, \code{"produced"},
\code{"canceled"}, \code{"failed"}, or \code{"completed"}.
}
}

\section{Creating an extract}{

\itemize{
\item Create an \code{ipums_extract} object from scratch with the appropriate
\code{\link[=define_extract]{define_extract_*()}} function. These functions take the
form \verb{define_extract_\{collection\}}.
\item Use \code{\link[=get_extract_info]{get_extract_info()}} to get the latest status of a submitted extract
request.
\item Use \code{\link[=get_extract_history]{get_extract_history()}} to obtain the extract definitions of
previously-submitted extract requests.
}
}

\section{Submitting an extract}{

\itemize{
\item Use \code{\link[=submit_extract]{submit_extract()}} to submit an extract request for processing through
the IPUMS API.
\item Use \code{\link[=wait_for_extract]{wait_for_extract()}} to periodically check the status of a submitted
extract request until it is ready to download.
\item Use \code{\link[=is_extract_ready]{is_extract_ready()}} to manually check whether a submitted extract
request is ready to download.
}
}

\section{Downloading an extract}{

\itemize{
\item Download the data contained in a completed extract with
\code{\link[=download_extract]{download_extract()}}.
}
}

\section{Saving an extract}{

\itemize{
\item Save an extract to a JSON-formatted file with \code{\link[=save_extract_as_json]{save_extract_as_json()}}.
\item Create an \code{ipums_extract} object from a saved JSON-formatted definition
with \code{\link[=define_extract_from_json]{define_extract_from_json()}}.
}
}

