#' Simulated multiple-group data
#'
#' This data set has a list consisting of item metadata, item response data, and group names of three simulated groups.
#'
#' @usage simMG
#'
#' @format This data set includes a list of three internal objects: (1) a list of item metadata (item.prm) for three groups,
#' (2) a list of item response data (res.dat) for the three groups, and (3) a vector of group names (group.name) for
#' the three groups.
#'
#' The first internal object (item.prm) contains a list of item metadata of three test forms for the three
#' groups. In terms of test forms, the test forms for the first and second groups have fifty items consisting of forty seven 3PLM
#' items and three GRM items. The test form for the third group has thirty eight items consisting of thirty seven 3PLM items and
#' one GRM item. Among the three forms, the first and second test forms share twelve common items (C1I1 through C1I12) and
#' the second and third test forms share ten common items (C2I1 through c2I10). There is no common item between the first and third forms.
#' The item parameters in the item metadata were used to simulate the item response data sets for the three groups (see the second
#' object of the list).
#'
#' Regrading the second internal object, all three response data sets were simulated with 2,000 latent abilities randomly sampled
#' from \eqn{N(0, 1)} (Group 1), \eqn{N(0.5, 0.8^{2})} (Group 2), and \eqn{N(-0.3, 1.3^{2})} (Group 3), respectively, using the
#' true item parameters provided in the item metadata.
#'
#' The third internal object is a vector of three group names which are "Group1", "Group2", and "Group3".
#'
#' @author Hwanggyu Lim \email{hglim83@@gmail.com}
#'
"simMG"
