% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_df.R
\name{shape_df}
\alias{shape_df}
\title{Create a data frame of item metadata}
\usage{
shape_df(
  par.drm = list(a = NULL, b = NULL, g = NULL),
  par.prm = list(a = NULL, d = NULL),
  item.id = NULL,
  cats,
  model,
  default.par = FALSE
)
}
\arguments{
\item{par.drm}{A list containing three vectors of dichotomous item parameters. Namely, the item discrimination (a), item difficulty (b),
and item guessing parameters.}

\item{par.prm}{A list containing a vector of polytomous item discrimination (or slope) parameters and a list of polytomous item threshold
(or step) parameters. In this list, the argument \code{a} should have a vector of slope parameters and the argument \code{d} should include
a list of threshold (or step) parameters. See below for more details.}

\item{item.id}{A character vector of item IDs. If NULL, an ID is automatically given to each item.}

\item{cats}{A vector containing the number of score categories for items.}

\item{model}{A character vector of IRT models corresponding to items. The available IRT models are "1PLM", "2PLM", "3PLM", and "DRM" for
dichotomous items, and "GRM" and "GPCM" for polytomous items. Note that "DRM" covers all dichotomous IRT models (i.e, "1PLM", "2PLM", and
"3PLM") and "GRM" and "GPCM" represent the graded response model and (generalized) partial credit model, respectively.}

\item{default.par}{A logical value to create an item meta with default item parameters. If TRUE, the number of score categories
and corresponding IRT models should be specified in the arguments of \code{cats} and \code{model}, respectively. In the default
item meta, the item slope parameter has a fixed value of 1, the item difficulty (or threshold) parameter(s) has(have) a fixed value of 0,
and the item guessing parameter has a fixed value of .2. Default is FALSE.}
}
\value{
This function returns a data frame.
}
\description{
This function creates a data frame which includes item meta (e.g., item parameter, categories, models ...) to be
used for the IRT model-data fit analysis as well as other analyses.
}
\details{
For any item where "1PLM" or "2PLM" is specified in \code{model}, the item guessing parameter will be NA. If \code{model} is
a vector of \eqn{length = 1}, the specified model is replicated across all items. As in the function \code{\link{simdat}}, it is important
to clearly specify \code{cats} according to the order of items in the test form when a data frame for a mixed-format test needs to be created.
See \code{\link{simdat}} for more details about how to specify \code{cats}.

When specifying item parameters in \code{par.drm} and/or \code{par.prm}, keep the order of item parameter types. For example,
in the \code{par.drm} argument, the first argument \code{a} should contain the slope parameter vector, the second argument \code{b}
should contain the difficulty vector, and the third argument \code{g} should contain the guessing parameter vector.
In the \code{par.drm} argument, the first argument \code{a} should contain the slope parameter vector and the second argument \code{d}
should contain a list including vectors of item threshold (or step) parameters for polytomous response IRT models. Note that when an item follows
the (generalized) partial credit model, the item step parameters are the overall item difficulty (or location) parameter subtracted by
the difficulty (or threshold) parameter for each category. Thus, the number of step parameters for item with m categories is m-1 because
a step parameter for the first category does not affect the category probabilities.
}
\examples{
## a mixed-item format test form
## with five dichotomous and two polytomous items
# create a list containing the dichotomous item parameters
par.drm <- list(
  a = c(1.1, 1.2, 0.9, 1.8, 1.4),
  b = c(0.1, -1.6, -0.2, 1.0, 1.2),
  g = rep(0.2, 5)
)

# create a list containing the polytomous item parameters
par.prm <- list(
  a = c(1.4, 0.6),
  d = list(
    c(0.0, -1.9, 1.2),
    c(0.4, -1.1, 1.5, 0.2)
  )
)

# create a numeric vector of score categories for the items
cats <- c(2, 4, 2, 2, 5, 2, 2)

# create a character vector of IRT models for the items
model <- c("DRM", "GRM", "DRM", "DRM", "GPCM", "DRM", "DRM")

# create an item meta set
shape_df(par.drm = par.drm, par.prm = par.prm, cats = cats, model = model)

## an empty item meta with five dichotomous and two polytomous items
# create a numeric vector of score categories for the items
cats <- c(2, 4, 3, 2, 5, 2, 2)

# create a character vector of IRT models for the items
model <- c("1PLM", "GRM", "GRM", "2PLM", "GPCM", "DRM", "3PLM")

# create an empty item meta set
shape_df(cats = cats, model = model, default.par = TRUE)

## an item meta for a single-item format test form with five dichotomous
shape_df(par.drm = par.drm, cats = rep(2, 5), model = "DRM")

}
\seealso{
\code{\link{info}}
}
\author{
Hwanggyu Lim \email{hglim83@gmail.com}
}
