% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isatools.R
\name{isa_properties}
\alias{isa_properties}
\title{Show properties associated with a node ID}
\usage{
isa_properties(x, node_id)
}
\arguments{
\item{x}{object of class isatab}

\item{node_id}{ID of a node}
}
\value{
Returns a named character vector. Names are the IDs of
properties associated with a given node, and values are the property
names.
}
\description{
Show properties associated with a node ID
}
\details{
Note: IDs are a thing internal to this R package. They are not imported
from or exported to actual ISA-tab files. However, given that the node
'identifiers' (e.g. 'Sample Name') can be ambiguous, IDs are necessary
to unambiguously identify a node.
}
\examples{
file <- system.file('extdata', 's_isatab.txt', package='isaeditor')
isa_s <- read_isa(file)
isa_properties(isa_s, 'ID1')
}
\seealso{
\code{\linkS4class{isatab}}, \code{\link[=isa_nodes]{isa_nodes()}}
}
