% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{readISATab}
\alias{readISATab}
\title{Read an ISA-Tab dataset into an R object.}
\usage{
readISATab(path = getwd(), zipfile = NULL, verbose = FALSE)
}
\arguments{
\item{path}{A character vector with the name of the directory in which the
ISA-Tab files are located (if the parameter zipfile is not provided or if it
is equal to \code{NULL}), or the name of the directory where the zip archive
containing the ISA-Tab files is located (if the parameter zipfile is not
\code{NULL}). The default value is the current working directory.}

\item{zipfile}{A character vector with the name of the zip archive containing
ISA-Tab files themselves (without a directory name in the zip archive). The
default value is \code{NULL} (specifying that the ISA-Tab files have not
been archived in one zipped file).}

\item{verbose}{Should the messages for the different reading steps be shown?}
}
\value{
An object of the \linkS4class{ISA} class.
}
\description{
Reads an ISA-Tab dataset, given as a zip file or as a set of files in a
specific folder, and builds an object of the \linkS4class{ISA} class.
}
\examples{
## Read example Atwell data set.
isaObject1 <- readISATab(path = file.path(system.file("extdata/Atwell",
                                          package = "isatabr")))

## Read example zipped Atwell data set.
isazip <- "Atwell.zip"
isaObject2 <- readISATab(path = file.path(system.file("extdata",
                                                      package = "isatabr")),
                         zipfile = isazip,
                         verbose = TRUE)

}
