% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isnigls.R
\name{isnigls}
\alias{isnigls}
\title{Function for ISNI computation when the outcome follows GLS.}
\usage{
isnigls(ymodel, gmodel, ycorr = "CS", predprobobs = NULL, misni = FALSE,
  alldata)
}
\arguments{
\item{ymodel}{an object of class "formula": a symbolic description of the model to be fitted for the outcome}

\item{gmodel}{an object of class "formula": a symbolic description of the selection model to be fitted for the missingness indictor g}

\item{ycorr}{the form of within-subject correlation structure.}

\item{predprobobs}{Null if using buil-in multinomial transitional logistic model to obtain predicted probabilities of being observed;
otherwise user supply a vector of these probabilities for all the observations in alldata.}

\item{misni}{FALSE if using the default approach to computing ISNI with a scalar nonignorability parameter; 
TRUE when computing ISNI with multiple nonignorability parameters.}

\item{alldata}{the name of data frame containing all the variables in the model and all the observations including those intended to be collected 
but became missing.}
}
\description{
Calculate the ISNI when the regression outcome is subject to missingness and follows generalized linear models (GLMs)
}
\examples{
ymodel= y~   t1+t3+t6 + group  + t12 + t32+t62 + perf + sever
gmodel= as.factor(g)~ t3+t6+group+yp+perf+sever
qolef$t12<-qolef$t1*qolef$group
qolef$t32<-qolef$t3*qolef$group
qolef$t62<-qolef$t6*qolef$group

qolef.isni=isnigls(ymode=ymodel, gmodel=gmodel, alldata=qolef)
summary(qolef.isni)

}
