% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIC.R
\name{X_absorption}
\alias{X_absorption}
\title{Relative rates of CO2 absorption reactions}
\usage{
X_absorption(temp, pH, S)
}
\arguments{
\item{temp}{The temperature of the solution (°C).}

\item{pH}{The pH of the solution.}

\item{S}{The salinity of the solution (g/kg or ‰).}
}
\value{
Returns a data frame with the relative rates of CO2 absorption reactions:
\itemize{
\item Relative rate of CO2 hydration (\%).
\item Relative rate of CO2 hydroxylation (\%).
}
}
\description{
\code{X_absorption()} calculates the relative abundance of the DIC species
as a function of solution temperature, pH, and salinity.
}
\details{
X_hydration = ((kCO2 / (kCO2 + kOHxKw / aH)) * 100), where
\itemize{
\item kCO2 is the rate constant for CO2 hydration from Johnson (1982)
\item kOHxKw is the rate constant for
CO2 hydroxylation x Kw from Schulz et al. (2006).
\item aH is 10^(-pH)
}
}
\examples{
X_absorption(temp = 25, pH = 7, S = 30)

}
\references{
Johnson, K. S. (1982).
Carbon dioxide hydration and dehydration kinetics in seawater.
Limnology and Oceanography, 27(5), 894-855.
\doi{10.4319/lo.1982.27.5.0849}

Schulz, K. G., Riebesell, U., Rost, B., Thoms, S., & Zeebe, R. E. (2006).
Determination of the rate constants for the carbon dioxide to
bicarbonate inter-conversion in pH-buffered seawater systems.
Marine Chemistry, 100(1-2), 53-65.
\doi{10.1016/j.marchem.2005.11.001}
}
