% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIC.R
\name{X_DIC}
\alias{X_DIC}
\title{Dissolved inorganic carbon species}
\usage{
X_DIC(temp, pH, S)
}
\arguments{
\item{temp}{The temperature of the solution (°C).}

\item{pH}{The pH of the solution.}

\item{S}{The salinity of the solution (g/kg or ‰).}
}
\value{
Returns a data frame with the relative abundance of the DIC species:
\itemize{
\item Relative abundance of dissolved CO2 (\%).
\item Relative abundance of bicarbonate ion (\%).
\item Relative abundance of carbonate ion (\%).
}
}
\description{
\code{X_DIC()} calculates the relative abundance of the DIC species
as a function of solution temperature, pH, and salinity.
}
\examples{
X_DIC(temp = 25, pH = 7, S = 30)

}
\references{
Harned, H. S., and Scholes, S. R. (1941).
The ionization constant of HCO3- from 0 to 50°.
J. Am. Chem. Soc., 63(6), 1706-1709.
\doi{10.1021/ja01851a058}

Harned, H. S., and Davis, R. (1943).
The ionization constant of carbonic acid in water and the solubility
of carbon dioxide in water and aqueous salt solutions from 0 to 50°.
J. Am. Chem. Soc., 65(10), 2030-2037.
\doi{10.1021/ja01250a059}

Millero, F. J., Graham, T. B., Huang, F., Bustos-Serrano, H., et al. (2006).
Dissociation constants of carbonic acid in seawater as a function of
salinity and temperature.
Mar. Chem., 100(1-2), 80-94.
\doi{10.1016/j.marchem.2005.12.001}
}
