% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a18.R
\name{a18_HCO3_H2O}
\alias{a18_HCO3_H2O}
\title{18O/16O fractionation factor between HCO3(-) and H2O}
\usage{
a18_HCO3_H2O(temp)
}
\arguments{
\item{temp}{Temperature (°C).}
}
\value{
Returns the 18O/16O fractionation factor.
}
\description{
\code{a18_HCO3_H2O()} calculates the 18O/16O fractionation factor
between bicarbonate ion HCO3(-) and water.
}
\details{
\deqn{\alpha^{18}_{HCO3(-)/H2O} =
e^{2.59 \times \frac{1000}{T^{2}} + 0.00189}}

The equation above and in the function is the uncorrected equation in
Beck et al. (2005). They experimentally determined the fractionation factor
using BaCO3 precipitation experiments. However, they applied the acid
fractionation factor of calcite during the data processing and
not that of BaCO3. The acid fractionation factor of BaCO3 is not known
accurately, which may result in a bias of up to 1‰
in the calculated 1000lna values.
}
\references{
Beck, W. C., Grossman, E. L., & Morse, J. W. (2005).
Experimental studies of oxygen isotope fractionation
in the carbonic acid system at 15°, 25°, and 40°C.
Geochimica et Cosmochimica Acta, 69(14), 3493-3503.
\doi{10.1016/j.gca.2005.02.003}
}
\seealso{
Other fractionation_factors: 
\code{\link{a13_CO2g_CO2aq}()},
\code{\link{a18_CO2acid_c}()},
\code{\link{a18_CO2aq_H2O}()},
\code{\link{a18_CO2g_H2O}()},
\code{\link{a18_CO3_H2O}()},
\code{\link{a18_H2O_OH}()},
\code{\link{a18_c_H2O}()},
\code{\link{a_A_B}()}
}
\concept{fractionation_factors}
