% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratio_functions.R
\name{orbi_summarize_results}
\alias{orbi_summarize_results}
\title{Generate the results table}
\usage{
orbi_summarize_results(dataset, ratio_method)
}
\arguments{
\item{dataset}{A processed tibble produced from \code{IsoX} output}

\item{ratio_method}{Method for computing the ratio}
}
\value{
Returns a results table containing \code{filename}, \code{compound},  \code{basepeak}, \code{Isotopocule}, \code{ratio}, \code{ratio_sem}, \code{ratio_relative_sem_permil}, \code{shot_noise_permil}, \code{No.of.Scans}, \code{minutes_to_1e6_ions}
}
\description{
Contains the logic to generate the results table. It passes the  \code{ratio_method} parameter to the \code{\link{orbi_calculate_ratios}} function for ratio calculations.
}
\details{
\strong{Description of the output columns:}
\itemize{
\item \code{basepeak}: Isotopocule used as denominator in ratio calculation.
\item \code{isotopocule}: Isotopocule used as numerator in ratio calculation.
\item \code{ratio_sem}: Standard error of the mean for the ratio
\item \code{number_of_scans}: Number of scans used for the final ratio calculation
\item \code{minutes_to_1e6_ions}: Time in minutes it would take to observe 1 million ions of the \code{isotopocule} used as numerator of the ratio calculation.
\item \code{shot_noise_permil}: Estimate of the shot noise (more correctly thermal noise) of the reported ratio in permil.
\item \code{ratio_relative_sem_permil}: Relative standard error of the reported ratio in permil
}
}
\examples{
fpath <- system.file("extdata", "testfile_flow.isox", package = "isoorbi")
df <- orbi_read_isox(file = fpath) \%>\%
      orbi_simplify_isox() \%>\% orbi_define_basepeak(basepeak_def = "M0")  \%>\%
      orbi_summarize_results(ratio_method = "sum")

}
