% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{orbi_define_basepeak}
\alias{orbi_define_basepeak}
\title{Define and assign the denominator for ratio calculation}
\usage{
orbi_define_basepeak(dataset, basepeak_def)
}
\arguments{
\item{dataset}{A tibble from a \code{IsoX} output. Needs to contain columns for \code{filename}, \code{compound}, \code{scan.no}, \code{isotopocule}, \code{ions.incremental}.}

\item{basepeak_def}{The isotopocule that gets defined as base peak, i.e. the denominator to calculate ratios}
}
\value{
Input data frame without the rows of the basepeak isotopocule and instead two new columns called \code{basepeak} and \code{basepeak_ions} holding the basepeak information
}
\description{
\code{orbi_define_basepeak()} sets one isotopocule in the data frame as the base peak (ratio denominator)
}
\examples{
fpath <- system.file("extdata", "testfile_flow.isox", package = "isoorbi")
df <- orbi_read_isox(file = fpath) |>
  orbi_simplify_isox() |>
  orbi_define_basepeak(basepeak_def = "M0")

}
