% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ternary_mean.R
\docType{methods}
\name{ternary_mean}
\alias{ternary_mean}
\alias{ternary_mean-method}
\alias{ternary_mean,numeric,numeric,numeric-method}
\alias{ternary_mean,ANY,missing,missing-method}
\title{Compositional Mean}
\usage{
ternary_mean(x, y, z, ...)

\S4method{ternary_mean}{numeric,numeric,numeric}(x, y, z, ...)

\S4method{ternary_mean}{ANY,missing,missing}(x, y, z, ...)
}
\arguments{
\item{x, y, z}{A \code{\link{numeric}} vector giving the x, y and z ternary coordinates
of a set of points. If \code{y} and \code{z} are missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xyz.coords]{grDevices::xyz.coords()}}).}

\item{...}{Further arguments to be passed to \code{\link[graphics:points]{graphics::points()}}.}
}
\value{
\code{ternary_mean()} is called it for its side-effects.
}
\description{
Computes and draws the closed geometric mean of the set of points specified.
}
\examples{
## Mean
## Data from Aitchison 1986
ternary_plot(lava, panel.first = ternary_grid())
ternary_mean(lava, pch = 16, col = "red")
ternary_confidence(lava, level = 0.95, border = "red", lty = 1)
}
\seealso{
Other statistics: 
\code{\link{ternary_contour}()},
\code{\link{ternary_density}()},
\code{\link{ternary_ellipse}()},
\code{\link{ternary_hull}()},
\code{\link{ternary_pca}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
