% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/units.R
\name{iso_with_units}
\alias{iso_with_units}
\alias{iso_double_with_units}
\title{Generate values with units}
\usage{
iso_with_units(x, units = "undefined units")

iso_double_with_units(x = double(), units = "undefined units")
}
\arguments{
\item{x}{the values (single value or vector)}

\item{units}{the units for the value, by default "undefined units" but this parameter should always be supplied when working with real data that has units}
}
\description{
These functions generate values with units that work well within data frames and tibbles and implement safety checks on operations that combine values with different units. To retrieve the value without units, use \code{\link{iso_strip_units}} (works for single variables and data frames/tibbles). To retrieve the unit use \code{\link{iso_get_units}}. Note that to correctly combine data frames / tibbles that have values with units in them, use \link[vctrs:vec_bind]{vec_rbind} instead of \link{rbind} or \link[dplyr:bind]{bind_rows}. \link[vctrs:vec_bind]{vec_rbind} will combine columns that have values with units if they have the same unit and otherwise convert back to plain values without units with a warning. The other functions will either fail or reduce the unit values to plain values with a cryptic warning message about not preserving attributes.
}
\details{
\code{iso_with_units} is the primary function to generate values with units. At present, only numeric values are supported so this function is just a shorter alias for the number-specific \code{iso_double_with_units}. It is not clear yet whether any non-numeric values with units make sense to be supported at a later point or whether integer and decimal numbers should be treated differently when they have units.
}
\seealso{
Other functions for values with units: 
\code{\link{iso_get_units}()},
\code{\link{iso_is_double_with_units}()},
\code{\link{iso_make_units_explicit}()},
\code{\link{iso_make_units_implicit}()},
\code{\link{iso_strip_units}()}

Other functions for values with units: 
\code{\link{iso_get_units}()},
\code{\link{iso_is_double_with_units}()},
\code{\link{iso_make_units_explicit}()},
\code{\link{iso_make_units_implicit}()},
\code{\link{iso_strip_units}()}
}
\concept{functions for values with units}
