% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoread.R
\name{read_iso_file}
\alias{read_iso_file}
\title{Read individual iso file}
\usage{
read_iso_file(
  ds,
  root,
  path,
  file_n,
  files_n,
  read_from_cache,
  read_from_old_cache,
  reread_outdated_cache,
  write_to_cache,
  cachepath,
  old_cachepath,
  post_read_check,
  ext,
  reader_fun,
  reader_options,
  reader_fun_env
)
}
\arguments{
\item{ds}{the basic data structure for the type of iso_file}

\item{root}{root directory for the isofiles. Can be relative to the current working directory (e.g. \code{"data"}) or an absolute path on the file system (e.g. \code{"/Users/..."} or \code{"C:/Data/.."}). The default is the current working directory (\code{"."}). Can be supplied as a vector of same length as the provided paths if the paths have different roots.}

\item{path}{file path}

\item{file_n}{number of processed file for info messages}

\item{files_n}{total number of files for info messages}

\item{read_from_cache}{whether to read from cache}

\item{read_from_old_cache}{whether to read from old cache files (to be deprecated in isoreader 2.0)}

\item{reread_outdated_cache}{whether to reread outdated cache files}

\item{write_to_cache}{whether to write to cache}

\item{cachepath}{path for the cache file}

\item{old_cachepath}{path for the old cache files}

\item{post_read_check}{whether to run data integrity checks after a file read}

\item{ext}{file extension}

\item{reader_fun}{file reader function}

\item{reader_options}{list of parameters to be passed on to the reader}

\item{reader_fun_env}{where to find the reader function}
}
\description{
Low level read function for an individual iso file. Usually not called directly but available for methods development.
}
