% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_predictions.R
\name{tidy_steady_states}
\alias{tidy_steady_states}
\title{Build a tidy table with the calculated steady states for each iteration}
\usage{
tidy_steady_states(nm, mcmc, n_per_chain = NULL, n = NULL)
}
\arguments{
\item{nm}{A \code{networkModel} object.}

\item{mcmc}{The corresponding output from \code{run_mcmc}.}

\item{n_per_chain}{Integer, number of iterations randomly drawn per
chain. Note that iterations are in sync across chains (in practice,
random iterations are chosen, and then parameter values extracted for
those same iterations from all chains).}

\item{n}{Integer, number of iterations randomly drawn from \code{mcmc}. Note
that iterations are *not* drawn in sync across chains in this case (use
\code{n_per_chain} if you need to have the same iterations taken across
all chains).}
}
\value{
A tidy table containing the mcmc iterations (chain, iteration,
    parameters), the grouping variables from the network model and the
    steady state sizes.
}
\description{
If neither \code{n_per_chain} and \code{n} are provided, all iterations are
used.
}
