% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoforest.R
\name{add.isolation.tree}
\alias{add.isolation.tree}
\title{Add additional (single) tree to isolation forest model}
\usage{
add.isolation.tree(model, df, sample_weights = NULL, column_weights = NULL)
}
\arguments{
\item{model}{An Isolation Forest object as returned by `isolation.forest`, to which an additional tree will be added.
The result of this function must be reassigned to `model`, and the old `model` should not be used any further.}

\item{df}{A `data.frame`, `data.table`, `tibble`, `matrix`, or sparse matrix (from package `Matrix` or `SparseM`, CSC format)
to which to fit the new tree.}

\item{sample_weights}{Sample observation weights for each row of 'X', with higher weights indicating
distribution density (i.e. if the weight is two, it has the same effect of including the same data
point twice). If not `NULL`, model must have been built with `weights_as_sample_prob` = `FALSE`.}

\item{column_weights}{Sampling weights for each column in `df`. Ignored when picking columns by deterministic criterion.
If passing `NULL`, each column will have a uniform weight. Cannot be used when weighting by kurtosis.}
}
\value{
No return value. The model is modified in-place.
}
\description{
Adds a single tree fit to the full (non-subsampled) data passed here. Must
have the same columns as previously-fitted data.
}
\details{
Important: this function will modify the model object in-place, but this modification will only affect the R
object in the environment in which it was called. If trying to use the same model object in e.g. its parent environment,
it will lead to issues due to the C++ object being modified but the R object remaining the same, so if this method is used
inside a function, make sure to output the newly-modified R object and have it replace the old R object outside the calling
function too.

The model object can be deep copied (including the underlying C++ object) through
function \link{deepcopy.isotree}.
}
\seealso{
\link{isolation.forest} \link{unpack.isolation.forest}
}
