% Generated by roxygen2 (4.0.1): do not edit by hand
\name{itee}
\alias{itee}
\title{Returns a list of n independent iterators from a single iterable object}
\usage{
itee(object, n = 2)
}
\arguments{
\item{object}{an iterable object}

\item{n}{the number of iterables to return}
}
\value{
a list of \code{n} iterators
}
\description{
Constructs a list of \code{n} iterators, each of which iterates through an
iterable \code{object}.
}
\examples{
# Creates a list of three iterators.
# Each iterator iterates through 1:5 independently.
iter_list <- itee(1:5, n=3)

# Consumes the first iterator
unlist(as.list(iter_list[[1]])) == 1:5

# We can iterate through the remaining two iterators in any order.
iterators::nextElem(iter_list[[2]]) # 1
iterators::nextElem(iter_list[[2]]) # 2

iterators::nextElem(iter_list[[3]]) # 1
iterators::nextElem(iter_list[[3]]) # 2

iterators::nextElem(iter_list[[2]]) # 3
iterators::nextElem(iter_list[[2]]) # 4
iterators::nextElem(iter_list[[2]]) # 5

iterators::nextElem(iter_list[[3]]) # 3
iterators::nextElem(iter_list[[3]]) # 4
iterators::nextElem(iter_list[[3]]) # 5
}

