% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itrax_reduce.R
\name{itrax_reduce}
\alias{itrax_reduce}
\title{Reduce Itrax XRF data}
\usage{
itrax_reduce(
  dataframe,
  names = c(1:length(breaks_lower)),
  breaks_lower,
  breaks_upper,
  fun = mean,
  edges = c(">=", "<"),
  by = NULL
)
}
\arguments{
\item{dataframe}{defines the name of the XRF data to reduce, usually a itraxR::itrax_import like tibble}

\item{names}{optional, a vector of the same length as `breaks`}

\item{breaks_lower}{a vector of the lower limit of each chunk}

\item{breaks_upper}{a vector of the upper limit of each chunk}

\item{fun}{the function to apply in order to reduce the data. Default is mean(), but sd() is also common}

\item{edges}{a vector of length 2 with the upper and lower bound behaviour; can be any of `<`, `<=`, `>`, `>=`}

\item{by}{if contiguous samples of even sizes are required, `by` defines the chunk size and will automatically generate `breaks`}
}
\value{
a tibble with the same number of rows as `breaks` and the same number of columns as `dataframe`
}
\description{
Reduces Itrax XRF data into arbitrary chunks using an arbitrary function.
This is useful when making direct comparisons between the Itrax XRF data and some other data collected at a lower resolution.
}
\examples{
itrax_reduce(dataframe = CD166_19_S1$xrf, by = 10)

}
