% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/inspect_residuals.R
\name{check_resid}
\alias{check_resid}
\title{Inspect residuals of regression models.}
\usage{
check_resid(model, AR_start = NULL, split_by = NULL)
}
\arguments{
\item{model}{A regression model, resulting from the functions
\code{\link[mgcv]{gam}} or \code{\link[mgcv]{bam}}, or \code{lm},
\code{glm}, \code{lmer}, or \code{glmer}.}

\item{AR_start}{Defaults to NULL.
Only use this when the model was run in an old versions of package
\code{mgcv} and the function cannot retrieve the used AR.start values from
the \code{model}. When an error is shown with newer versions of
\code{mgcv}, please check the column provided as values of AR.start.
when using old versions of package \code{mgcv}.
Function will give error when it cannot find AR.start.}

\item{split_by}{A names list indicating time series in the data.}
}
\description{
Inspect residuals of regression models.
}
\section{Note}{

In the ACF plots, black lines indicate ACF of standard residuals, red
vertical lines indicate the ACF for the residuals corrected for the AR1
model included.
}
\examples{
data(simdat)

\dontrun{
# Add start event column:
simdat <- start_event(simdat, event=c("Subject", "Trial"))
head(simdat)
# bam model with AR1 model (toy example, not serious model):
m1 <- bam(Y ~ Group + te(Time, Trial, by=Group),
   data=simdat, rho=.5, AR.start=simdat$start.event)
# No time series specified:
check_resid(m1)
# Time series specified:
check_resid(m1, split_by=list(Subject=simdat$Subject, Trial=simdat$Trial))
# Note: residuals do not look very good.

# This does not work (see acf_resid for similar examples):
check_resid(m1, split_by=c("Subject", "Trial"))
# However, it does work for included predictors:
check_resid(m1, split_by=c("Group"))
}
}
\author{
Jacolien van Rij
}

