% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot_utility_functions.R
\name{getFigCoords}
\alias{getFigCoords}
\title{Get the figure region as coordinates of the current plot region.}
\usage{
getFigCoords(input = "f")
}
\arguments{
\item{input}{Text string: 'f' (figure, default), 'p' (plot region),
'hf' (half way figure region), or 'hp' (half way plot region)}
}
\value{
A vector of the form c(x1, x2, y1, y2) giving the
boundaries of the figure region as coordinates of the current
plot region.
}
\description{
Get the figure region as coordinates of the current plot region.
}
\examples{
# setup plot region:
emptyPlot(1,1, bty='o')
fc <- getFigCoords()
pc <- getFigCoords('p')
arrows(x0=pc[c(1,2,1,2)], x1=fc[c(1,2,1,2)],
    y0=pc[c(3,3,4,4)], y1=fc[c(3,3,4,4)], xpd=TRUE)

# Same plot with different axis:
emptyPlot(c(250,500),c(331, 336), bty='o')
fc <- getFigCoords()
pc <- getFigCoords('p')
arrows(x0=pc[c(1,2,1,2)], x1=fc[c(1,2,1,2)],
    y0=pc[c(3,3,4,4)], y1=fc[c(3,3,4,4)], xpd=TRUE)
hc <-  getFigCoords('h')

# other options:
# 1. center of figure region:
abline(v=getFigCoords('hf')[1], col='blue', xpd=TRUE)
abline(h=getFigCoords('hf')[2], col='blue', xpd=TRUE)
# 2. center of plot region:
abline(v=getFigCoords('hp')[1], col='red', lty=3)
abline(h=getFigCoords('hp')[2], col='red', lty=3)
}
\author{
Jacolien van Rij
}
\seealso{
Other Utility functions for plotting: \code{\link{addInterval}};
  \code{\link{alphaPalette}}; \code{\link{alpha}};
  \code{\link{color_contour}}; \code{\link{dotplot_error}};
  \code{\link{emptyPlot}}; \code{\link{errorBars}};
  \code{\link{fadeRug}}; \code{\link{fill_area}};
  \code{\link{find_difference}}; \code{\link{getCoords}};
  \code{\link{gradientLegend}}; \code{\link{horiz_error}};
  \code{\link{plot_error}}
}

