% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predictions.R
\name{get_predictions}
\alias{get_predictions}
\title{Get model predictions for specific conditions.}
\usage{
get_predictions(model, cond = NULL, se = TRUE, f = 1.96,
  rm.ranef = NULL, print.summary = getOption("itsadug_print"))
}
\arguments{
\item{model}{A gam object, produced by \code{\link[mgcv]{gam}} or
\code{\link[mgcv]{bam}}.}

\item{cond}{A named list of the values to use for the predictor terms.
Variables omitted from this list will have the closest observed value to
the median for continuous variables, or the reference level for factors.}

\item{se}{Logical: whether or not to return the confidence interval or
standard error around the estimates.}

\item{f}{A number to scale the standard error. Defaults to 1.96, resulting
in 95\% confidence intervals. For 99\% confidence intervals use a value of
2.58.}

\item{rm.ranef}{Logical: whether or not to remove random effects.
Default is FALSE. Alternatively a string (or vector of strings) with the
name of the random effect(s) to remove.}

\item{print.summary}{Logical: whether or not to print a summary of the
values selected for each predictor.
Default set to the print info messages option
(see \code{\link{infoMessages}}).}
}
\value{
A data frame with estimates and optionally errors.
}
\description{
Get model predictions for specific conditions.
}
\examples{
data(simdat)

m1 <- bam(Y ~ Group + s(Time, by=Group), data=simdat)

# Time value is automatically set:
pp <- get_predictions(m1, cond=list(Group="Adults"))
head(pp)

# Range of time values:
pp <- get_predictions(m1,
    cond=list(Group="Adults", Time=seq(0,500,length=100)))
# plot:
emptyPlot(500, range(pp$fit), h=0)
plot_error(pp$Time, pp$fit, pp$CI, shade=TRUE, xpd=TRUE)

# Warning: also unrealistical values are possible
range(simdat$Time)
pp <- get_predictions(m1,
    cond=list(Group="Adults", Time=seq(-500,0,length=100)))
# plot of predictions that are not supported by data:
emptyPlot(c(-500,0), range(pp$fit), h=0)
plot_error(pp$Time, pp$fit, pp$CI, shade=TRUE, xpd=TRUE)
}
\author{
Jacolien van Rij
}
\seealso{
Other functions for model predictions: \code{\link{get_coefs}};
  \code{\link{get_difference}};
  \code{\link{get_modelterm}}; \code{\link{get_random}};
  \code{\link{inspect_random}}; \code{\link{plotsurface}}
}

