% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{convertNonAlphanumeric}
\alias{convertNonAlphanumeric}
\title{Prepare string for regular expressions 
(backslash for all non-letter and non-digit characters)}
\usage{
convertNonAlphanumeric(text)
}
\arguments{
\item{text}{A text string (smooth term label) that needs to be converted 
to a regular expression.}
}
\value{
A regular expression string.
}
\description{
Prepare string for regular expressions 
(backslash for all non-letter and non-digit characters)
}
\examples{
data(simdat)
# Model for illustrating coefficients:
m0 <- bam(Y ~ s(Time) + s(Subject, bs='re') 
+ s(Time, Subject, bs='re'), data=simdat)

# get all coefficients:
coef(m0)
# to get only the Subject intercepts:
coef(m0)[grepl(convertNonAlphanumeric("s(Subject)"), names(coef(m0)))]
# to get only the Subject slopes:
coef(m0)[grepl(convertNonAlphanumeric("s(Time,Subject)"), names(coef(m0)))]

}
\seealso{
Other Utility functions: \code{\link{diff_terms}},
  \code{\link{find_difference}}, \code{\link{missing_est}},
  \code{\link{print_summary}}, \code{\link{summary_data}},
  \code{\link{timeBins}}
}
\author{
Jacolien van Rij
}
