% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.PAConversion}
\alias{print.PAConversion}
\title{Print summary information from PAConversion object.}
\usage{
\method{print}{PAConversion}(x, ...)
}
\arguments{
\item{x}{(\code{PAConversion}) A PAConversion object to be messaged.
It could be the return of function \code{\link{convert_to_pa}}.}

\item{...}{Not used.}
}
\value{
The same object that was passed as input.
}
\description{
Display the most general and informative characteristics of
a PAConversion object.
}
\examples{
\donttest{
# Using a pseudo presence-only occurrence dataset of
# virtual species provided in this package
library(dplyr)
library(sf)
library(stars)
library(itsdm)

data("occ_virtual_species")
occ_virtual_species <- occ_virtual_species \%>\%
  mutate(id = row_number())

set.seed(11)
occ <- occ_virtual_species \%>\% sample_frac(0.7)
occ_test <- occ_virtual_species \%>\% filter(! id \%in\% occ$id)
occ <- occ \%>\% select(-id)
occ_test <- occ_test \%>\% select(-id)

env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars() \%>\%
  slice('band', c(1, 5, 12, 16))

mod <- isotree_po(
  occ = occ, occ_test = occ_test,
  variables = env_vars, ntrees = 50,
  sample_rate = 0.8, ndim = 1L,
  seed = 123L, response = FALSE,
  spatial_response = FALSE,
  check_variable = FALSE)

# Threshold conversion
pa_thred <- convert_to_pa(mod$prediction, method = 'threshold', beta = 0.5)
print(pa_thred)
}

}
\seealso{
\code{\link{convert_to_pa}}, \code{\link{plot.PAConversion}}
}
