% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monobound.R
\name{genboundA}
\alias{genboundA}
\title{Generating the LP constraint matrix for bounds}
\usage{
genboundA(A0, A1, sset, gridobj, uname, m0.lb, m0.ub, m1.lb, m1.ub, mte.lb,
  mte.ub)
}
\arguments{
\item{A0}{the matrix of values from evaluating the MTR for control
observations over the grid generated to perform the audit. This
matrix will be incorporated into the final constraint matrix
for the bounds.}

\item{A1}{the matrix of values from evaluating the MTR for control
observations over the grid generated to perform the audit. This
matrix will be incorporated into the final constraint matrix
for the bounds.}

\item{sset}{a list containing the point estimates and gamma
components associated with each element in the S-set.}

\item{gridobj}{a list containing the grid over which the
monotonicity and boundedness conditions are imposed on.}

\item{uname}{name declared by user to represent the unobservable
term.}

\item{m0.lb}{scalar, lower bound on MTR for control group.}

\item{m0.ub}{scalar, upper bound on MTR for control group.}

\item{m1.lb}{scalar, lower bound on MTR for treated group.}

\item{m1.ub}{scalar, upper bound on MTR for treated group.}

\item{mte.lb}{scalar, lower bound on MTE.}

\item{mte.ub}{scalar, upper bound on MTE.}
}
\value{
a constraint matrix for the LP problem, the associated
    vector of inequalities, and the RHS vector in the inequality
    constraint. The objects pertain only to the boundedness
    constraints declared by the user.
}
\description{
This function generates the component of the constraint matrix in
the LP problem pertaining to bounds on the MTRs and MTEs. These
bounds are declared by the user.
}
