% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{package}
\name{jSonarR}
\alias{jSonarR}
\alias{jSonarR-package}
\title{jSonar Analytics Platform API for R}
\description{
This package enables users to access MongoDB by running queries
and returning their results in R data frames. Usually, data in MongoDB is
only available in the form of a JSON document. jSonarR uses data
processing and conversion capabilities in the jSonar Analytics Platform
and the JSON Studio Gateway (http://www.jsonstudio.com), to convert it to
a tabular format which is easy to use with existing R packages.
}
\details{
To use jSonarR, you must have access to a server running JSON Studio.
Create a connection using using \code{\link{new.SonarConnection}}. Now
you can run a saved query against a collection in the database using the
connection object and \code{\link{sonarAgg}} or \code{\link{sonarFind}}.
}
\examples{
connection <- new.SonarConnection('https://example.com', 'localhost', 'test')

ny_by_day <- sonarAgg(connection, 'delays_by_day', 'NYCFlights')
summary(ny_by_day)

tx_to_co <- sonarFind(connection, 'flights_to', 'TXFlights',
  bind=list(state="CO"),
  colClasses=c(DAY_OF_MONTH='factor', DEST_AIRPORT_ID='factor'))
summary(tx_to_co$DEST_AIRPORT_ID)
}
\seealso{
MongoDB \url{http://www.mongodb.org}

JSON Studio \url{http://www.jsonstudio.com}
}
\keyword{connection}
\keyword{database}

