% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sonarJSON}
\alias{sonarJSON}
\title{Get a JSON document for a saved query}
\usage{
sonarJSON(connection, queryName, queryCol, type, bind = list(),
  limit = NULL, publishedBy = NULL)
}
\arguments{
\item{connection}{a SonarConnection object created with
\code{\link{new.SonarConnection}}}

\item{queryName}{the name of the saved query to execute}

\item{queryCol}{a collection in the database to use with the query}

\item{type}{the type of query to execute ('agg' or 'find')}

\item{bind}{a list of bind variables and their values}

\item{limit}{the maximum number of results to return}

\item{publishedBy}{the name of the user who we expect published the API}
}
\description{
Execute a query which has been saved and published in JSON Studio Finder,
and get the response in an R object that is structured like a JSON
document. This object is generated by the jsonlite package.
}
\details{
The parameters for this function are explained in greater detail in the
JSON Studio help page \emph{Using the Gateway}.
}
\examples{
connection <- new.SonarConnection('https://example.com', 'localhost', 'test')

delays <- sonarJSON(connection, 'delayed_flights', 'ExampleFlights', type='find', limit=5)
summary(delays$Origin$city)
}
\seealso{
\url{http://jsonstudio.com/wp-content/uploads/2014/04/manual141/_build/html/index.html}

Other connection: \code{\link{new.SonarConnection}};
  \code{\link{sonarAgg}}; \code{\link{sonarCSV}};
  \code{\link{sonarFind}}
}
\keyword{database}

