% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/julia.R
\name{toLaTeX}
\alias{toLaTeX}
\title{Exact expression to LaTeX}
\usage{
toLaTeX(poly, asCharacter = FALSE)
}
\arguments{
\item{poly}{an \code{exactmvp} object, that is, a polynomial with an exact
expression}

\item{asCharacter}{Boolean, whether to return a character string; if
\code{FALSE}, the LaTeX code is printed}
}
\value{
A character string if \code{asCharacter=TRUE}, otherwise it is also
  returned but invisibly, and it is printed in the console.
}
\description{
LaTeX form of the exact expression of a polynomial.
}
\examples{
library(jack)
\donttest{if(JuliaConnectoR::juliaSetupOk()){
  julia <- Jack_julia()
  ( pol <- julia$ZonalQPol(m = 2, lambda = c(3, 2)) )
  toLaTeX(pol)
  JuliaConnectoR::stopJulia()
}}
}
